/*
 * Decompiled with CFR 0.152.
 */
package org.streamingpool.core.domain;

import io.reactivex.BackpressureOverflowStrategy;
import io.reactivex.Flowable;
import io.reactivex.processors.PublishProcessor;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.streamingpool.core.domain.ErrorStreamException;
import org.streamingpool.core.domain.ErrorStreamPair;

public final class ErrorDeflector {
    private static final Logger LOGGER = LoggerFactory.getLogger(ErrorDeflector.class);
    private final PublishProcessor<Throwable> errorStream = PublishProcessor.create();

    private ErrorDeflector() {
    }

    public static final ErrorDeflector create() {
        return new ErrorDeflector();
    }

    public void deflectExceptions(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Exception e) {
            this.deflectOperationError(runnable, e);
        }
    }

    public <T> T deflectExceptions(Supplier<T> supplier, T defaultValue) {
        try {
            return supplier.get();
        }
        catch (Exception e) {
            this.deflectOperationError(supplier, e);
            return defaultValue;
        }
    }

    public <T> Optional<T> emptyOnException(Supplier<T> callable) {
        try {
            return Optional.of(callable.get());
        }
        catch (Exception e) {
            this.deflectOperationError(callable, e);
            return Optional.empty();
        }
    }

    public <S, T> io.reactivex.functions.Function<S, Optional<T>> emptyOnException(Function<S, T> function) {
        return val -> {
            try {
                return Optional.of(function.apply(val));
            }
            catch (Exception e) {
                this.deflectOperationIncomingError(function, val, e);
                return Optional.empty();
            }
        };
    }

    @Deprecated
    public <S, T> io.reactivex.functions.Function<S, Optional<T>> emptyOnError(Function<S, T> function) {
        return this.emptyOnException(function);
    }

    public <T> io.reactivex.functions.Predicate<T> falseOnException(Predicate<T> predicate) {
        return it -> {
            try {
                return predicate.test(it);
            }
            catch (Exception e) {
                this.deflectOperationIncomingError(predicate, it, e);
                return false;
            }
        };
    }

    @Deprecated
    public <T> io.reactivex.functions.Predicate<T> falseOnError(Predicate<T> predicate) {
        return this.falseOnException(predicate);
    }

    public void publishException(Throwable exception) {
        this.errorStream.onNext((Object)exception);
    }

    private <T> void deflectOperationIncomingError(Object operation, T incoming, Exception e) {
        ErrorStreamException exception = new ErrorStreamException("Error in operation " + operation + ". Incoming value: " + incoming, e);
        this.errorStream.onNext((Object)exception);
    }

    private void deflectOperationError(Object operation, Exception e) {
        ErrorStreamException exception = new ErrorStreamException("Error in operation " + operation + ".", e);
        this.errorStream.onNext((Object)exception);
    }

    public <T> ErrorStreamPair<T> stream(Publisher<T> dataPublisher) {
        return ErrorStreamPair.ofDataError(dataPublisher, (Publisher<Throwable>)this.errorStream.toSerialized().onBackpressureBuffer((long)Flowable.bufferSize(), () -> LOGGER.error("Discarding exception due to backpressure buffer limit"), BackpressureOverflowStrategy.DROP_OLDEST));
    }

    public <T> ErrorStreamPair<T> streamNonEmpty(Publisher<Optional<T>> optionalPublisher) {
        return this.stream((Publisher<T>)Flowable.fromPublisher(optionalPublisher).filter(Optional::isPresent).map(Optional::get));
    }
}

