/*
 * Decompiled with CFR 0.152.
 */
package org.streamingpool.core.domain;

import io.reactivex.Flowable;
import java.util.Objects;
import org.reactivestreams.Publisher;

public abstract class ErrorStreamPair<T> {
    private static final EmptyStream<?> EMPTY_STREAM = new EmptyStream();

    public abstract Publisher<T> data();

    public abstract Publisher<Throwable> error();

    public abstract boolean isPresent();

    public static final <T> ErrorStreamPair<T> empty() {
        return EMPTY_STREAM;
    }

    public static final <T> ErrorStreamPair<T> ofDataError(Publisher<T> dataStream, Publisher<Throwable> errorStream) {
        return new NonEmptyStream<T>(dataStream, errorStream);
    }

    public static final <T> ErrorStreamPair<T> ofData(Publisher<T> dataStream) {
        return ErrorStreamPair.ofDataError(dataStream, (Publisher<Throwable>)Flowable.never());
    }

    private static class EmptyStream<T>
    extends ErrorStreamPair<T> {
        private EmptyStream() {
        }

        @Override
        public Publisher<T> data() {
            throw new UnsupportedOperationException("Empty Stream! This call is not allowed.");
        }

        @Override
        public Publisher<Throwable> error() {
            throw new UnsupportedOperationException("Empty Stream! This call is not allowed.");
        }

        @Override
        public boolean isPresent() {
            return false;
        }
    }

    private static class NonEmptyStream<T>
    extends ErrorStreamPair<T> {
        private final Publisher<T> data;
        private final Publisher<Throwable> error;

        public NonEmptyStream(Publisher<T> data, Publisher<Throwable> error) {
            this.data = Objects.requireNonNull(data, "dataStream must not be null");
            this.error = Objects.requireNonNull(error, "errorStream must not be null");
        }

        @Override
        public Publisher<T> data() {
            return this.data;
        }

        @Override
        public Publisher<Throwable> error() {
            return this.error;
        }

        @Override
        public boolean isPresent() {
            return true;
        }
    }
}

