/*
 * Decompiled with CFR 0.152.
 */
package org.streamingpool.core.domain;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.streamingpool.core.domain.StreamDependencyTree;
import org.streamingpool.core.service.StreamId;

public class SynchronizedStreamDependencyTree
implements StreamDependencyTree {
    private final Multimap<StreamId<?>, StreamId<?>> dependencies = HashMultimap.create();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDependency(StreamId<?> source, StreamId<?> parent) {
        Multimap<StreamId<?>, StreamId<?>> multimap = this.dependencies;
        synchronized (multimap) {
            this.dependencies.put(source, parent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<StreamId<?>> getAncestorsFrom(StreamId<?> source) {
        Multimap<StreamId<?>, StreamId<?>> multimap = this.dependencies;
        synchronized (multimap) {
            Collection ancestors = this.dependencies.get(source);
            if (ancestors.isEmpty()) {
                return ImmutableSet.of(source);
            }
            Set ancestorsId = ancestors.stream().flatMap(ancestor -> this.getAncestorsFrom((StreamId<?>)ancestor).stream()).collect(Collectors.toSet());
            return ImmutableSet.builder().add(source).addAll(ancestorsId).build();
        }
    }
}

