/*
 * Decompiled with CFR 0.152.
 */
package org.streamingpool.core.domain.backpressure;

import org.streamingpool.core.domain.backpressure.BackpressureBufferStrategy;
import org.streamingpool.core.domain.backpressure.BackpressureDropStrategy;
import org.streamingpool.core.domain.backpressure.BackpressureLatestStrategy;
import org.streamingpool.core.domain.backpressure.BackpressureNoneStrategy;
import org.streamingpool.core.domain.backpressure.BackpressureStrategy;

public final class BackpressureStrategies {
    public static final BackpressureBufferStrategy.BackpressureBufferOverflowStrategy DEFAULT_BUFFER_OVERFLOW_STRATEGY = BackpressureBufferStrategy.BackpressureBufferOverflowStrategy.DROP_LATEST;
    public static final int DEFAULT_BUFFER_SIZE = 100;
    private static final BackpressureBufferStrategy DEFAULT_BUFFER_STRATEGY = new BackpressureBufferStrategy(100, DEFAULT_BUFFER_OVERFLOW_STRATEGY);
    private static final BackpressureNoneStrategy BACKPRESSURE_NONE_STRATEGY = new BackpressureNoneStrategy();
    private static final BackpressureLatestStrategy BACKPRESSURE_LATEST_STRATEGY = new BackpressureLatestStrategy();
    private static final BackpressureDropStrategy BACKPRESSURE_DROP_STRATEGY = new BackpressureDropStrategy();

    private BackpressureStrategies() {
    }

    public static BackpressureStrategy onBackpressureBuffer() {
        return DEFAULT_BUFFER_STRATEGY;
    }

    public static BackpressureStrategy onBackpressureBuffer(int bufferSize) {
        return new BackpressureBufferStrategy(bufferSize, DEFAULT_BUFFER_OVERFLOW_STRATEGY);
    }

    public static BackpressureStrategy onBackpressureBuffer(int bufferSize, BackpressureBufferStrategy.BackpressureBufferOverflowStrategy overflowStrategy) {
        return new BackpressureBufferStrategy(bufferSize, overflowStrategy);
    }

    public static BackpressureStrategy onBackpressureDrop() {
        return BACKPRESSURE_DROP_STRATEGY;
    }

    public static BackpressureStrategy onBackpressureLatest() {
        return BACKPRESSURE_LATEST_STRATEGY;
    }

    public static BackpressureStrategy defaultBackpressureStrategy() {
        return BackpressureStrategies.onBackpressureLatest();
    }

    public static BackpressureStrategy none() {
        return BACKPRESSURE_NONE_STRATEGY;
    }
}

