/*
 * Decompiled with CFR 0.152.
 */
package org.streamingpool.core.service.streamfactory;

import io.reactivex.Flowable;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.streamingpool.core.domain.ErrorStreamPair;
import org.streamingpool.core.service.DiscoveryService;
import org.streamingpool.core.service.StreamFactory;
import org.streamingpool.core.service.StreamId;
import org.streamingpool.core.service.streamid.DelayedStreamId;

public class DelayedStreamFactory
implements StreamFactory {
    public <Y> ErrorStreamPair<Y> create(StreamId<Y> id, DiscoveryService discoveryService) {
        if (!(id instanceof DelayedStreamId)) {
            return ErrorStreamPair.empty();
        }
        DelayedStreamId delayedId = (DelayedStreamId)id;
        Duration delay = delayedId.getDelay();
        StreamId target = delayedId.getTarget();
        return ErrorStreamPair.ofData(Flowable.fromPublisher(discoveryService.discover(target)).delay(delay.toMillis(), TimeUnit.MILLISECONDS));
    }
}

