/*
 * Decompiled with CFR 0.152.
 */
package org.streamingpool.core.service.streamfactory;

import io.reactivex.Flowable;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.streamingpool.core.domain.ErrorStreamPair;
import org.streamingpool.core.service.DiscoveryService;
import org.streamingpool.core.service.StreamFactory;
import org.streamingpool.core.service.StreamId;
import org.streamingpool.core.service.streamid.FlattenedStreamId;

public class FlattenedStreamFactory
implements StreamFactory {
    @Override
    public <T> ErrorStreamPair<T> create(StreamId<T> id, DiscoveryService discoveryService) {
        if (!(id instanceof FlattenedStreamId)) {
            return ErrorStreamPair.empty();
        }
        FlattenedStreamId flattenedStreamId = (FlattenedStreamId)id;
        return this.createFlattenedStream(flattenedStreamId, discoveryService);
    }

    private <T> ErrorStreamPair<T> createFlattenedStream(FlattenedStreamId<T> id, DiscoveryService discoveryService) {
        Flowable sourceStream = Flowable.fromPublisher(discoveryService.discover(id.sourceStreamId()));
        return ErrorStreamPair.ofData(sourceStream.flatMap(iterable -> {
            Stream<Object> stream = StreamSupport.stream(iterable.spliterator(), false).filter(Objects::nonNull);
            return Flowable.fromIterable((Iterable)stream.collect(Collectors.toList()));
        }));
    }
}

