/*
 * Decompiled with CFR 0.152.
 */
package org.streamingpool.core.service.streamfactory;

import io.reactivex.Flowable;
import java.util.Set;
import java.util.stream.Collectors;
import org.streamingpool.core.domain.ErrorStreamPair;
import org.streamingpool.core.domain.StreamDependencyTree;
import org.streamingpool.core.service.DiscoveryService;
import org.streamingpool.core.service.InstrumentationService;
import org.streamingpool.core.service.StreamFactory;
import org.streamingpool.core.service.StreamId;
import org.streamingpool.core.service.diagnostic.ErrorStreamId;
import org.streamingpool.core.service.streamid.MergedErrorStreamId;

public class MergedErrorStreamFactory
implements StreamFactory {
    private final InstrumentationService instrumentationService;

    public MergedErrorStreamFactory(InstrumentationService instrumentationService) {
        this.instrumentationService = instrumentationService;
    }

    @Override
    public <T> ErrorStreamPair<T> create(StreamId<T> id, DiscoveryService discoveryService) {
        if (!(id instanceof MergedErrorStreamId)) {
            return ErrorStreamPair.empty();
        }
        MergedErrorStreamId streamId = (MergedErrorStreamId)id;
        StreamDependencyTree dependencies = this.instrumentationService.dependencyTree();
        Set dependenciesOfSource = dependencies.getAncestorsFrom(streamId.getSourceStreamId()).stream().map(ErrorStreamId::of).map(discoveryService::discover).collect(Collectors.toSet());
        Flowable merge = Flowable.merge(dependenciesOfSource);
        return ErrorStreamPair.ofData(merge);
    }
}

