/*
 * Decompiled with CFR 0.152.
 */
package org.streamingpool.core.service.streamid;

import io.reactivex.Flowable;
import java.time.Duration;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiPredicate;
import org.streamingpool.core.service.StreamId;

public class BufferSpecification {
    private StreamId<?> startId;
    private Set<EndStreamMatcher<?, ?>> endStreamMatchers;
    private Flowable<?> timeout;
    private static final Duration NO_TIMEOUT = Duration.ofSeconds(-1L);

    private BufferSpecification(StreamId<?> startStreamId, Set<EndStreamMatcher<?, ?>> endStreamMatchers, Flowable<?> timeout) {
        this.startId = Objects.requireNonNull(startStreamId, "startStreamId must not be null.");
        this.endStreamMatchers = Objects.requireNonNull(endStreamMatchers, "endStreamId must not be null.");
        this.timeout = Objects.requireNonNull(timeout, "timeout must not be null");
    }

    public static BufferSpecification ofStartEndTimeout(StreamId<?> startStreamId, Set<EndStreamMatcher<?, ?>> endStreamMatchers, Duration timeout) {
        return new BufferSpecification(startStreamId, endStreamMatchers, BufferSpecification.timeoutStreamOf(timeout));
    }

    public static BufferSpecification ofStartEndTimeout(StreamId<?> startStreamId, Set<EndStreamMatcher<?, ?>> endStreamMatchers, Flowable<?> timeout) {
        return new BufferSpecification(startStreamId, endStreamMatchers, timeout);
    }

    public static BufferSpecification ofStartEnd(StreamId<?> startStreamId, Set<EndStreamMatcher<?, ?>> endStreamMatchers) {
        return new BufferSpecification(startStreamId, endStreamMatchers, BufferSpecification.timeoutStreamOf(NO_TIMEOUT));
    }

    private static Flowable<?> timeoutStreamOf(Duration timeout) {
        if (timeout.isNegative()) {
            return Flowable.never();
        }
        return Flowable.timer((long)timeout.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public StreamId<?> startId() {
        return this.startId;
    }

    public Set<EndStreamMatcher<?, ?>> endStreamMatchers() {
        return this.endStreamMatchers;
    }

    public Flowable<?> timeout() {
        return this.timeout;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.endStreamMatchers == null ? 0 : this.endStreamMatchers.hashCode());
        result = 31 * result + (this.startId == null ? 0 : this.startId.hashCode());
        result = 31 * result + (this.timeout == null ? 0 : this.timeout.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BufferSpecification other = (BufferSpecification)obj;
        if (this.endStreamMatchers == null ? other.endStreamMatchers != null : !this.endStreamMatchers.equals(other.endStreamMatchers)) {
            return false;
        }
        if (this.startId == null ? other.startId != null : !this.startId.equals(other.startId)) {
            return false;
        }
        return !(this.timeout == null ? other.timeout != null : !this.timeout.equals(other.timeout));
    }

    public String toString() {
        return "BufferSpecification [startId=" + this.startId + ", endStreamMatchers=" + this.endStreamMatchers + ", timeout=" + this.timeout + "]";
    }

    public static class EndStreamMatcher<T, U> {
        private final StreamId<U> endStreamId;
        private final BiPredicate<T, U> matching;

        public EndStreamMatcher(StreamId<U> endStreamId, BiPredicate<T, U> matching) {
            this.endStreamId = endStreamId;
            this.matching = matching;
        }

        public static final <T, U> EndStreamMatcher<T, U> endingOnMatch(StreamId<U> endStreamId, BiPredicate<T, U> matching) {
            return new EndStreamMatcher<T, U>(endStreamId, matching);
        }

        public static final <U> EndStreamMatcher<?, U> endingOnEvery(StreamId<U> endStreamId) {
            return EndStreamMatcher.endingOnMatch(endStreamId, (a, b) -> true);
        }

        public static final <U> EndStreamMatcher<?, U> endingOnEquals(StreamId<U> endStreamId) {
            return EndStreamMatcher.endingOnMatch(endStreamId, Objects::equals);
        }

        public StreamId<U> endStreamId() {
            return this.endStreamId;
        }

        public BiPredicate<T, U> matching() {
            return this.matching;
        }
    }
}

