/*
 * Decompiled with CFR 0.152.
 */
package org.streamingpool.core.service.streamid;

import java.util.Objects;
import org.streamingpool.core.domain.backpressure.BackpressureAware;
import org.streamingpool.core.domain.backpressure.BackpressureStrategies;
import org.streamingpool.core.domain.backpressure.BackpressureStrategy;
import org.streamingpool.core.service.StreamId;

public class FanOutStreamId<T>
implements StreamId<T>,
BackpressureAware {
    private static final long serialVersionUID = 1L;
    private final StreamId<T> target;
    private final BackpressureStrategy backpressureStrategy;

    private FanOutStreamId(StreamId<T> target, BackpressureStrategy backpressureStrategy) {
        this.target = Objects.requireNonNull(target);
        this.backpressureStrategy = Objects.requireNonNull(backpressureStrategy);
    }

    public static <T> FanOutStreamId<T> fanOut(StreamId<T> target, BackpressureStrategy backpressureStrategy) {
        return new FanOutStreamId<T>(target, backpressureStrategy);
    }

    public static <T> FanOutStreamId<T> fanOut(StreamId<T> target) {
        return new FanOutStreamId<T>(target, BackpressureStrategies.defaultBackpressureStrategy());
    }

    public StreamId<T> target() {
        return this.target;
    }

    @Override
    public BackpressureStrategy backpressureStrategy() {
        return this.backpressureStrategy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FanOutStreamId that = (FanOutStreamId)o;
        return Objects.equals(this.target, that.target) && Objects.equals(this.backpressureStrategy, that.backpressureStrategy);
    }

    public int hashCode() {
        return Objects.hash(this.target, this.backpressureStrategy);
    }

    public String toString() {
        return "FanOutStreamId{target=" + this.target + ", backpressureStrategy=" + this.backpressureStrategy + '}';
    }
}

