/*
 * Decompiled with CFR 0.152.
 */
package org.streamingpool.core.service.streamid;

import java.util.Objects;
import org.streamingpool.core.service.StreamId;

public class FlattenedStreamId<T>
implements StreamId<T> {
    private static final long serialVersionUID = 1L;
    private final StreamId<? extends Iterable<? extends T>> sourceStreamId;

    public static <T> FlattenedStreamId<T> flatten(StreamId<? extends Iterable<? extends T>> sourceStreamId) {
        return new FlattenedStreamId<T>(sourceStreamId);
    }

    public FlattenedStreamId(StreamId<? extends Iterable<? extends T>> sourceStreamId) {
        this.sourceStreamId = Objects.requireNonNull(sourceStreamId, "sourceStreamId must not be null");
    }

    public StreamId<? extends Iterable<? extends T>> sourceStreamId() {
        return this.sourceStreamId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.sourceStreamId == null ? 0 : this.sourceStreamId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FlattenedStreamId other = (FlattenedStreamId)obj;
        return !(this.sourceStreamId == null ? other.sourceStreamId != null : !this.sourceStreamId.equals(other.sourceStreamId));
    }

    public String toString() {
        return "FlattenedStreamId [sourceStreamId=" + this.sourceStreamId + "]";
    }
}

