/*
 * Decompiled with CFR 0.152.
 */
package org.streamingpool.core.service.streamid;

import java.util.concurrent.TimeUnit;
import org.streamingpool.core.service.StreamId;

public class IntervalStreamId
implements StreamId<Long> {
    private static final long serialVersionUID = 1L;
    private final long period;
    private final TimeUnit periodTimeUnit;
    private final long initialDelay;
    private final TimeUnit initialDelayTimeUnit;

    private IntervalStreamId(long initialDelay, TimeUnit initialDelayTimeUnit, long period, TimeUnit periodTimeUnit) {
        this.periodTimeUnit = periodTimeUnit;
        this.initialDelayTimeUnit = initialDelayTimeUnit;
        this.period = period;
        this.initialDelay = initialDelay;
    }

    public static final IntervalStreamId every(long period, TimeUnit timeUnit) {
        return new IntervalStreamId(0L, TimeUnit.SECONDS, period, timeUnit);
    }

    public final IntervalStreamId delayedBy(long newInitialDelay, TimeUnit timeUnit) {
        return new IntervalStreamId(newInitialDelay, timeUnit, this.period, this.periodTimeUnit);
    }

    public TimeUnit getPeriodTimeUnit() {
        return this.periodTimeUnit;
    }

    public long getInitialDelay() {
        return this.initialDelay;
    }

    public long getPeriod() {
        return this.period;
    }

    public TimeUnit getInitialDelayTimeUnit() {
        return this.initialDelayTimeUnit;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.initialDelay ^ this.initialDelay >>> 32);
        result = 31 * result + (int)(this.period ^ this.period >>> 32);
        result = 31 * result + (this.periodTimeUnit == null ? 0 : this.periodTimeUnit.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntervalStreamId other = (IntervalStreamId)obj;
        if (this.initialDelay != other.initialDelay) {
            return false;
        }
        if (this.period != other.period) {
            return false;
        }
        return this.periodTimeUnit == other.periodTimeUnit;
    }

    public String toString() {
        return "IntervalStreamId [period=" + this.period + ", periodTimeUnit=" + (Object)((Object)this.periodTimeUnit) + ", initialDelay=" + this.initialDelay + ", initialDelayTimeUnit=" + (Object)((Object)this.initialDelayTimeUnit) + "]";
    }
}

