/*
 * Decompiled with CFR 0.152.
 */
package org.streamingpool.core.service.streamid;

import io.reactivex.functions.BiFunction;
import java.util.Objects;
import java.util.Optional;
import org.streamingpool.core.service.StreamId;

public class ZippedStreamId<S1, S2, T>
implements StreamId<T> {
    private static final long serialVersionUID = 1L;
    private final StreamId<S1> sourceStreamId1;
    private final StreamId<S2> sourceStreamId2;
    private final BiFunction<S1, S2, Optional<T>> function;

    private ZippedStreamId(StreamId<S1> sourceStreamId1, StreamId<S2> sourceStreamId2, BiFunction<S1, S2, Optional<T>> function) {
        this.sourceStreamId1 = sourceStreamId1;
        this.sourceStreamId2 = sourceStreamId2;
        this.function = Objects.requireNonNull(function, "function must not be null");
    }

    public static <S1, S2, T> ZippedStreamId<S1, S2, T> zip(StreamId<S1> sourceStreamId1, StreamId<S2> sourceStreamId2, BiFunction<S1, S2, Optional<T>> function) {
        Objects.requireNonNull(sourceStreamId1, "sourceStreamId1 must not be null");
        Objects.requireNonNull(sourceStreamId2, "sourceStreamId2 must not be null");
        return new ZippedStreamId<S1, S2, T>(sourceStreamId1, sourceStreamId2, function);
    }

    public StreamId<S1> sourceStreamId1() {
        return this.sourceStreamId1;
    }

    public StreamId<S2> sourceStreamId2() {
        return this.sourceStreamId2;
    }

    public BiFunction<S1, S2, Optional<T>> function() {
        return this.function;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZippedStreamId that = (ZippedStreamId)o;
        if (this.sourceStreamId1 != null ? !this.sourceStreamId1.equals(that.sourceStreamId1) : that.sourceStreamId1 != null) {
            return false;
        }
        if (this.sourceStreamId2 != null ? !this.sourceStreamId2.equals(that.sourceStreamId2) : that.sourceStreamId2 != null) {
            return false;
        }
        return this.function != null ? this.function.equals(that.function) : that.function == null;
    }

    public int hashCode() {
        int result = this.sourceStreamId1 != null ? this.sourceStreamId1.hashCode() : 0;
        result = 31 * result + (this.sourceStreamId2 != null ? this.sourceStreamId2.hashCode() : 0);
        result = 31 * result + (this.function != null ? this.function.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ZippedStreamId{sourceStreamId1=" + this.sourceStreamId1 + ", sourceStreamId2=" + this.sourceStreamId2 + ", function=" + this.function + '}';
    }
}

