/*
 * Decompiled with CFR 0.152.
 */
package org.streamingpool.core.service.streamid.factory;

import io.reactivex.Flowable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import org.springframework.util.CollectionUtils;
import org.streamingpool.core.service.StreamId;
import org.streamingpool.core.service.streamid.CompositionStreamId;
import org.streamingpool.core.service.streamid.DelayedStreamId;
import org.streamingpool.core.service.streamid.DerivedStreamId;
import org.streamingpool.core.service.streamid.FilteredStreamId;
import org.streamingpool.core.service.streamid.factory.function.FlatMapCompositionFunction;
import org.streamingpool.core.service.streamid.factory.function.ZipCompositionFunction;

@Deprecated
public final class ComposedStreams {
    private ComposedStreams() {
    }

    public static final <X, T> StreamId<T> mappedStream(StreamId<X> sourceStreamId, Function<X, T> conversion) {
        Objects.requireNonNull(sourceStreamId, "sourceStreamId");
        Objects.requireNonNull(conversion, "conversion");
        return DerivedStreamId.derive(sourceStreamId, conversion);
    }

    public static final <X, T> StreamId<T> flatMappedStream(StreamId<X> sourceStreamId, Function<X, Publisher<T>> conversion) {
        Objects.requireNonNull(sourceStreamId, "sourceStreamId");
        Objects.requireNonNull(conversion, "conversion");
        return new CompositionStreamId(sourceStreamId, new FlatMapCompositionFunction<X, T>(conversion));
    }

    public static final <X> StreamId<X> mergedStream(List<StreamId<X>> sourceStreamIds) {
        ComposedStreams.checkCollectionAndThrow(sourceStreamIds, "sourceStreamIds");
        return new CompositionStreamId(sourceStreamIds, reactiveStreams -> {
            ArrayList<Flowable> observablesToMerge = new ArrayList<Flowable>();
            for (Publisher reactiveStream : reactiveStreams) {
                observablesToMerge.add(Flowable.fromPublisher((Publisher)reactiveStream));
            }
            return Flowable.merge(observablesToMerge);
        });
    }

    public static final <X> StreamId<X> filteredStream(StreamId<X> sourceStreamId, Predicate<X> predicate) {
        Objects.requireNonNull(sourceStreamId, "sourceStreamId");
        Objects.requireNonNull(predicate, "predicate");
        return new FilteredStreamId<X>(sourceStreamId, predicate);
    }

    public static final <X> StreamId<X> delayedStream(StreamId<X> sourceStreamId, Duration duration) {
        Objects.requireNonNull(sourceStreamId, "sourceStreamId");
        Objects.requireNonNull(duration, "duration");
        return new DelayedStreamId<X>(sourceStreamId, duration);
    }

    public static final <X, T> StreamId<T> zippedStream(StreamId<X> sourceStreamId1, StreamId<X> sourceStreamId2, BiFunction<X, X, Optional<T>> zip) {
        Objects.requireNonNull(sourceStreamId1, "sourceStreamId1");
        Objects.requireNonNull(sourceStreamId2, "sourceStreamId2");
        Objects.requireNonNull(zip, "zip");
        return new CompositionStreamId(Arrays.asList(sourceStreamId1, sourceStreamId2), new ZipCompositionFunction<X, T>(zip));
    }

    private static void checkCollectionAndThrow(Collection<?> collection, String collectionName) {
        if (CollectionUtils.isEmpty(collection)) {
            throw new IllegalArgumentException("The collection " + collectionName + " cannot be null nor empty");
        }
    }
}

