/*
 * Decompiled with CFR 0.152.
 */
package org.streamingpool.core.testing;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import io.reactivex.Flowable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.reactivestreams.Publisher;
import org.streamingpool.core.domain.ErrorStreamPair;
import org.streamingpool.core.service.DiscoveryService;
import org.streamingpool.core.service.StreamFactory;
import org.streamingpool.core.service.StreamId;

public class StreamFactoryMock<T> {
    private final Multimap<StreamId<T>, StreamId<T>> withIdDiscover = HashMultimap.create();
    private final Map<StreamId<T>, T> withIdProvideStreamWithValue = new HashMap<StreamId<T>, T>();
    private final Map<StreamId<T>, BiFunction<StreamId<T>, DiscoveryService, Publisher<T>>> withIdInvoke = new HashMap<StreamId<T>, BiFunction<StreamId<T>, DiscoveryService, Publisher<T>>>();

    private StreamFactoryMock() {
    }

    public static <T> StreamFactoryMock<T> newFactory(Class<T> factoryOfType) {
        return new StreamFactoryMock<T>();
    }

    public StreamFactoryMock<T> withIdDiscoverAnother(StreamId<T> id, StreamId<T> idToDiscover) {
        this.withIdDiscover.put(id, idToDiscover);
        return this;
    }

    public StreamFactoryMock<T> withIdProvideStreamWithValue(StreamId<T> id, T value) {
        this.withIdProvideStreamWithValue.put(id, value);
        return this;
    }

    public StreamFactoryMock<T> withIdInvoke(StreamId<T> id, BiFunction<StreamId<T>, DiscoveryService, Publisher<T>> bifunction) {
        this.withIdInvoke.put(id, bifunction);
        return this;
    }

    public StreamFactory build() {
        StreamFactory factoryMock = (StreamFactory)Mockito.mock(StreamFactory.class);
        Mockito.when(factoryMock.create((StreamId)Matchers.any(), (DiscoveryService)Matchers.any())).thenAnswer(args -> {
            StreamId streamId = (StreamId)args.getArgument(0);
            DiscoveryService discovery = (DiscoveryService)args.getArgument(1);
            if (this.withIdDiscover.containsKey((Object)streamId)) {
                return ErrorStreamPair.ofData(Flowable.merge((Iterable)this.withIdDiscover.get((Object)streamId).stream().map(discovery::discover).collect(Collectors.toList())));
            }
            if (this.withIdProvideStreamWithValue.containsKey(streamId)) {
                return ErrorStreamPair.ofData(Flowable.just(this.withIdProvideStreamWithValue.get(streamId)));
            }
            if (this.withIdInvoke.containsKey(streamId)) {
                return ErrorStreamPair.ofData(this.withIdInvoke.get(streamId).apply(streamId, discovery));
            }
            return ErrorStreamPair.empty();
        });
        return factoryMock;
    }
}

