/*
 * Decompiled with CFR 0.152.
 */
package org.streamingpool.core.conf;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.reactivex.schedulers.Schedulers;
import java.util.Arrays;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.streamingpool.core.conf.PoolConfiguration;

@Configuration
public class DefaultPoolConfiguration {
    public static final String STREAMINGPOOL_THREAD_POOL_SIZE = "streamingpool.threadPoolSize";
    public static final String STREAMINGPOOL_THREAD_POOL_KEEP_ALIVE_SECONDS = "streamingpool.threadPoolKeepAliveSeconds";
    public static final String STREAMINGPOOL_THREAD_POOL_USE_DAEMON_THREADS = "streamingpool.threadPoolUseDaemonThreads";
    public static final String STREAMINGPOOL_OBSERVE_ON_CAPACITY = "streamingpool.observeOnCapacity";
    @Value(value="${streamingpool.threadPoolSize:100}")
    private int threadPoolSize;
    @Value(value="${streamingpool.observeOnCapacity:128}")
    private int observeOnCapacity;
    @Value(value="${streamingpool.threadPoolKeepAliveSeconds:60}")
    private long keepAliveTimeSeconds;
    @Value(value="${streamingpool.threadPoolUseDaemonThreads:false}")
    private boolean useDaemonThreads;

    @Bean(destroyMethod="shutdown")
    @Conditional(value={NoTestSchedulerPresent.class})
    public ExecutorService localPoolExecutorService() {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(this.useDaemonThreads).setNameFormat("streamingpool-thread-%d").build();
        return new ThreadPoolExecutor(this.threadPoolSize, this.threadPoolSize, this.keepAliveTimeSeconds, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
    }

    @Bean
    @Conditional(value={NoTestSchedulerPresent.class})
    public PoolConfiguration localPoolConfiguration(ExecutorService localPoolExecutorService) {
        return new PoolConfiguration(Schedulers.from((Executor)localPoolExecutorService), this.observeOnCapacity);
    }

    private static class NoTestSchedulerPresent
    implements Condition {
        private NoTestSchedulerPresent() {
        }

        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            Environment env = context.getEnvironment();
            return Arrays.stream(env.getActiveProfiles()).noneMatch("streamingpool.test.scheduler"::equals);
        }
    }
}

