/*
 * Decompiled with CFR 0.152.
 */
package org.streamingpool.core.conf;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.streamingpool.core.conf.DefaultPoolConfiguration;
import org.streamingpool.core.conf.PoolConfiguration;
import org.streamingpool.core.conf.TestPoolConfiguration;
import org.streamingpool.core.service.InstrumentationService;
import org.streamingpool.core.service.StreamFactory;
import org.streamingpool.core.service.impl.InstrumentationServiceImpl;
import org.streamingpool.core.service.impl.LocalPool;
import org.streamingpool.core.service.impl.PoolContent;
import org.streamingpool.core.util.MoreCollections;

@Configuration
@Import(value={TestPoolConfiguration.class, DefaultPoolConfiguration.class})
public class EmbeddedPoolConfiguration {
    @Autowired(required=false)
    private List<StreamFactory> streamFactories;

    @Bean(destroyMethod="shutdown")
    public PoolContent poolContent() {
        return new PoolContent();
    }

    @Bean
    public InstrumentationService instrumentationService(PoolContent content) {
        return new InstrumentationServiceImpl(content);
    }

    @Bean
    public LocalPool pool(PoolConfiguration poolConfiguration, PoolContent content) {
        return new LocalPool(MoreCollections.emptyIfNull(this.streamFactories), poolConfiguration, content);
    }
}

