/*
 * Decompiled with CFR 0.152.
 */
package org.streamingpool.core.rx.process;

import io.reactivex.Flowable;
import io.reactivex.processors.BehaviorProcessor;
import java.util.Objects;
import org.streamingpool.core.rx.process.Choosable;

public class ObservableChoosable<T>
implements Choosable<T> {
    private final BehaviorProcessor<Iterable<T>> allValuesSubject;
    private final BehaviorProcessor<T> actualValueSubject;

    private ObservableChoosable(Iterable<T> allValues, T defaultValue) {
        Objects.requireNonNull(defaultValue, "the default value must not be null");
        Objects.requireNonNull(allValues, "allValues must not be null");
        this.actualValueSubject = BehaviorProcessor.createDefault(defaultValue);
        this.allValuesSubject = BehaviorProcessor.createDefault(allValues);
    }

    public static <T> ObservableChoosable<T> allWithDefault(Iterable<T> allValues, T defaultValue) {
        return new ObservableChoosable<T>(allValues, defaultValue);
    }

    @Override
    public void choose(T newlySelected) {
        Objects.requireNonNull(newlySelected, "the newly selected object must not be null");
        this.actualValueSubject.onNext(newlySelected);
    }

    public Flowable<Iterable<T>> allOptions() {
        return this.allValuesSubject;
    }

    public Flowable<T> choice() {
        return this.actualValueSubject;
    }
}

