/*
 * Decompiled with CFR 0.152.
 */
package org.streamingpool.core.service.impl;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.streamingpool.core.conf.PoolConfiguration;
import org.streamingpool.core.domain.ErrorStreamPair;
import org.streamingpool.core.service.DiscoveryService;
import org.streamingpool.core.service.ProvidingService;
import org.streamingpool.core.service.StreamFactory;
import org.streamingpool.core.service.StreamFactoryRegistry;
import org.streamingpool.core.service.StreamId;
import org.streamingpool.core.service.impl.PoolContent;
import org.streamingpool.core.service.impl.TrackKeepingDiscoveryService;

public class LocalPool
implements DiscoveryService,
ProvidingService,
StreamFactoryRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalPool.class);
    private final PoolConfiguration poolConfiguration;
    private final List<StreamFactory> factories;
    private final PoolContent content;

    public LocalPool(List<StreamFactory> factories, PoolConfiguration poolConfiguration, PoolContent content) {
        Objects.requireNonNull(factories, "Factories can not be null");
        this.factories = new CopyOnWriteArrayList<StreamFactory>(factories);
        LOGGER.info("Available Stream Factories: {}", factories);
        this.poolConfiguration = poolConfiguration;
        this.content = content;
    }

    @Override
    public <T> void provide(StreamId<T> id, Publisher<T> obs) {
        Objects.requireNonNull(id, "id must not be null!");
        Objects.requireNonNull(obs, "stream must not be null!");
        boolean inserted = this.content.synchronousPutIfAbsent(id, () -> ErrorStreamPair.ofData(obs));
        if (!inserted) {
            throw new IllegalArgumentException("Id " + id + " already registered! Cannot register twice.");
        }
    }

    @Override
    public <T> Publisher<T> discover(StreamId<T> id) {
        Objects.requireNonNull(id, "Cannot discover a null id");
        return new TrackKeepingDiscoveryService(this.factories, this.content, this.poolConfiguration).discover(id);
    }

    @Override
    public void addIntercept(StreamFactory interceptFactory) {
        this.factories.add(0, interceptFactory);
        LOGGER.info("Intercept {} has been added to the factories", (Object)interceptFactory);
    }

    @Override
    public void addFallback(StreamFactory fallbackFactory) {
        this.factories.add(this.factories.size(), fallbackFactory);
        LOGGER.info("Fallback {} has been added to the factories", (Object)fallbackFactory);
    }
}

