/*
 * Decompiled with CFR 0.152.
 */
package org.streamingpool.core.service.streamfactory;

import io.reactivex.Flowable;
import java.util.function.Predicate;
import org.streamingpool.core.domain.ErrorDeflector;
import org.streamingpool.core.domain.ErrorStreamPair;
import org.streamingpool.core.service.DiscoveryService;
import org.streamingpool.core.service.StreamFactory;
import org.streamingpool.core.service.StreamId;
import org.streamingpool.core.service.streamid.FilteredStreamId;

public class FilteredStreamFactory
implements StreamFactory {
    @Override
    public <T> ErrorStreamPair<T> create(StreamId<T> id, DiscoveryService discoveryService) {
        if (!(id instanceof FilteredStreamId)) {
            return ErrorStreamPair.empty();
        }
        FilteredStreamId filteredId = (FilteredStreamId)id;
        StreamId source = filteredId.sourceStreamId();
        Predicate predicate = filteredId.predicate();
        ErrorDeflector ed = ErrorDeflector.create();
        return ed.stream(Flowable.fromPublisher(discoveryService.discover(source)).filter(ed.falseOnException(predicate)));
    }
}

