/*
 * Decompiled with CFR 0.152.
 */
package org.streamingpool.core.service.streamfactory;

import io.reactivex.Flowable;
import java.util.concurrent.TimeUnit;
import org.streamingpool.core.domain.ErrorDeflector;
import org.streamingpool.core.domain.ErrorStreamPair;
import org.streamingpool.core.service.DiscoveryService;
import org.streamingpool.core.service.StreamFactory;
import org.streamingpool.core.service.StreamId;
import org.streamingpool.core.service.streamid.IntervalStreamId;

public class IntervalStreamFactory
implements StreamFactory {
    @Override
    public <T> ErrorStreamPair<T> create(StreamId<T> id, DiscoveryService discoveryService) {
        if (!(id instanceof IntervalStreamId)) {
            return ErrorStreamPair.empty();
        }
        IntervalStreamId typedId = (IntervalStreamId)id;
        ErrorDeflector ed = ErrorDeflector.create();
        Flowable dataPublisher = Flowable.interval((long)typedId.getPeriod(), (TimeUnit)typedId.getPeriodTimeUnit()).delay(typedId.getInitialDelay(), typedId.getInitialDelayTimeUnit());
        return ed.stream(dataPublisher);
    }
}

