/*
 * Decompiled with CFR 0.152.
 */
package org.streamingpool.core.service.streamid;

import java.io.Serializable;
import java.time.Duration;
import java.util.Objects;
import org.streamingpool.core.service.StreamId;

public class DelayedStreamId<T>
implements StreamId<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final StreamId<T> target;
    private final Duration delay;

    public static <T> DelayedStreamId<T> delayBy(StreamId<T> target, Duration delay) {
        return new DelayedStreamId<T>(target, delay);
    }

    public DelayedStreamId(StreamId<T> target, Duration delay) {
        this.target = Objects.requireNonNull(target, "target of the delay must not be null");
        this.delay = Objects.requireNonNull(delay, "delay must not be null");
    }

    public StreamId<T> getTarget() {
        return this.target;
    }

    public Duration getDelay() {
        return this.delay;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.delay == null ? 0 : this.delay.hashCode());
        result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DelayedStreamId other = (DelayedStreamId)obj;
        if (this.delay == null ? other.delay != null : !this.delay.equals(other.delay)) {
            return false;
        }
        return !(this.target == null ? other.target != null : !this.target.equals(other.target));
    }

    public String toString() {
        return "DelayedStreamId [target=" + this.target + ", delay=" + this.delay + "]";
    }
}

