/*
 * Decompiled with CFR 0.152.
 */
package org.streamingpool.core.service.streamid.factory.function;

import io.reactivex.Flowable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.reactivestreams.Publisher;

public class ZipCompositionFunction<X, T>
implements Function<List<Publisher<X>>, Publisher<T>> {
    private final BiFunction<X, X, Optional<T>> conversion;

    public ZipCompositionFunction(BiFunction<X, X, Optional<T>> conversion) {
        Objects.requireNonNull(conversion, "conversion");
        this.conversion = conversion;
    }

    @Override
    public Publisher<T> apply(List<Publisher<X>> reactiveStreams) {
        return Flowable.zip((Publisher)Flowable.fromPublisher(reactiveStreams.get(0)), (Publisher)Flowable.fromPublisher(reactiveStreams.get(1)), this.conversion::apply).filter(Optional::isPresent).map(Optional::get);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZipCompositionFunction that = (ZipCompositionFunction)o;
        return this.conversion.equals(that.conversion);
    }

    public int hashCode() {
        return this.conversion.hashCode();
    }
}

