/*
 * Decompiled with CFR 0.152.
 */
package org.streamingpool.core.service.util;

import java.util.Objects;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.streamingpool.core.service.StreamCreator;
import org.streamingpool.core.service.StreamId;
import org.streamingpool.core.service.impl.IdentifiedStreamCreator;
import org.streamingpool.core.service.impl.ImmutableIdentifiedStreamCreator;

public final class StreamCreators {
    private StreamCreators() {
    }

    public static <T> OngoingCreatorCreation<T> create(StreamCreator<T> creator) {
        return new OngoingCreatorCreation<T>(creator);
    }

    public static <T> OngoingCreatorCreation<T> create(Supplier<Publisher<T>> supplier) {
        return new OngoingCreatorCreation(discovery -> (Publisher)supplier.get());
    }

    public static class OngoingCreatorCreation<T> {
        private final StreamCreator<T> streamCreator;

        public OngoingCreatorCreation(StreamCreator<T> streamCreator) {
            this.streamCreator = Objects.requireNonNull(streamCreator, "streamCreator must not be null.");
        }

        public IdentifiedStreamCreator<T> as(StreamId<T> streamId) {
            return ImmutableIdentifiedStreamCreator.of(streamId, this.streamCreator);
        }
    }
}

