/*
 * Decompiled with CFR 0.152.
 */
package cern.online.analysis.core;

import cern.online.analysis.core.expression.AssertionExpression;
import cern.online.analysis.core.names.ExpressionNames;
import cern.streaming.pool.core.names.resolve.Chains;
import cern.streaming.pool.core.names.resolve.Names;
import cern.streaming.pool.core.service.streamid.DerivedStreamId;
import cern.streaming.pool.core.service.streamid.OverlapBufferStreamId;
import cern.streaming.pool.ext.tensorics.expression.StreamIdBasedExpression;
import cern.streaming.pool.ext.tensorics.streamid.ExpressionBasedStreamId;
import java.util.Iterator;
import java.util.function.Function;
import org.tensorics.core.expressions.BinaryPredicateExpression;
import org.tensorics.core.expressions.ConversionOperationExpression;
import org.tensorics.core.tree.domain.Expression;
import org.tensorics.core.tree.domain.Node;
import org.tensorics.core.tree.domain.ResolvedExpression;
import org.tensorics.core.tree.domain.ResolvingContext;
import org.tensorics.core.tree.walking.Trees;
import org.tensorics.expression.PredicateExpression;

public class ResolvedSnapshot<R, E extends Expression<R>> {
    private final ResolvingContext context;
    private final Function<Object, String> nameRepository;
    private final Function<Object, String> nameResolving;
    private final E root;

    public ResolvedSnapshot(E rootExpression, ResolvingContext context, Function<Object, String> nameRepository) {
        this.root = rootExpression;
        this.context = context;
        this.nameRepository = nameRepository;
        this.nameResolving = this.createFullNameResolving();
    }

    private final Function<Object, String> createFullNameResolving() {
        return (Function)((Chains.ChainBuilder)((Chains.ChainBuilder)((Chains.ChainBuilder)((Chains.ChainBuilder)((Chains.ChainBuilder)((Chains.ChainBuilder)((Chains.BiFunctionBranchBuilder)((Chains.ChainBuilder)((Chains.ChainBuilder)((Chains.ChainBuilder)((Chains.ChainBuilder)((Chains.BiFunctionBranchBuilder)((Chains.ChainBuilder)((Chains.ChainBuilder)((Chains.ChainBuilder)Chains.chain().or(this.nameRepository)).or(Names.FROM_NAME_METHOD)).or(Names::fromGetNameMethod)).branchCase(AssertionExpression.class, Names.FROM_NAME_METHOD).or(ExpressionNames.FROM_ASSERTION_EXPRESSION)).orElseNull()).branchCase(BinaryPredicateExpression.class, ExpressionNames.FROM_BINARY_PREDICATE_EXPRESSION).orElseNull()).branchCase(ResolvedExpression.class, ExpressionNames.FROM_RESOLVED_EXPRESSION).orElseNull()).branchCase(PredicateExpression.class, ExpressionNames.FROM_PREDICATE_EXPRESSION).orElseNull()).branchCase(ConversionOperationExpression.class, Names.FROM_NAME_METHOD).or(ExpressionNames.FROM_CONVERSION_EXPRESSION)).orElseNull()).branchCase(StreamIdBasedExpression.class, ExpressionNames::fromStreambasedExpression).orElseNull()).branchCase(OverlapBufferStreamId.class, (id, f) -> (String)f.apply(id.sourceId())).orElseNull()).branchCase(ExpressionBasedStreamId.class, (id, f) -> (String)f.apply(id.getDetailedId())).orElseNull()).branchCase(DerivedStreamId.class, (id, f) -> (String)f.apply(id.conversion()) + "(" + (String)f.apply(id.sourceStreamId()) + ")").orElseNull()).or(Names::fromSimpleClassName)).orElseNull();
    }

    public String detailedStringFor(Node exp) {
        StringBuffer detailedResult = new StringBuffer();
        Iterator iterator = Trees.findBottomNodes((Node)exp).iterator();
        if (iterator.hasNext()) {
            Node child = (Node)iterator.next();
            String childResult = this.context.resolvedValueOf((Expression)child).toString();
            return "DETAIL String not resolved";
        }
        return detailedResult.toString();
    }

    public String nameFor(AssertionExpression exp) {
        return this.nameResolving.apply((Object)exp);
    }

    public String nameFor(Node exp) {
        return this.nameResolving.apply(exp);
    }

    public ResolvingContext context() {
        return this.context;
    }

    public E root() {
        return this.root;
    }

    public Function<Object, String> nameRepository() {
        return this.nameRepository;
    }
}

