/*
 * Decompiled with CFR 0.152.
 */
package org.streamingpool.ext.analysis.expression;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.streamingpool.ext.analysis.AssertionBuilder;
import org.streamingpool.ext.analysis.AssertionStatus;
import org.tensorics.core.commons.operations.Conversion;
import org.tensorics.core.tree.domain.AbstractDeferredExpression;
import org.tensorics.core.tree.domain.ExceptionHandlingNode;
import org.tensorics.core.tree.domain.Expression;
import org.tensorics.expression.CombinedBooleanExpression;
import org.tensorics.expression.IterableResolvingExpression;

public class AssertionExpression
extends AbstractDeferredExpression<AssertionStatus>
implements ExceptionHandlingNode<AssertionStatus> {
    private final String name;
    private final Expression<Boolean> condition;
    private final Expression<Boolean> preConditionsExpression;

    public AssertionExpression(AssertionBuilder builder) {
        Objects.requireNonNull(builder.condition(), "conditions must not be null");
        Objects.requireNonNull(builder.preConditions(), "preconditions must not be null");
        Objects.requireNonNull(builder.preConditionsReducer(), "preConditionsCollector must not be null");
        this.name = builder.name();
        this.condition = builder.condition();
        this.preConditionsExpression = new CombinedBooleanExpression((Conversion)builder.preConditionsReducer(), (Expression)new IterableResolvingExpression(builder.preConditions()));
    }

    public List<Expression<Boolean>> getChildren() {
        return ImmutableList.of(this.condition, this.preConditionsExpression);
    }

    public Expression<Boolean> condition() {
        return this.condition;
    }

    public Expression<Boolean> preConditionsExpression() {
        return this.preConditionsExpression;
    }

    public String name() {
        return this.name;
    }

    public AssertionStatus handle(Exception exception) {
        return AssertionStatus.ERROR;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.condition == null ? 0 : this.condition.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        AssertionExpression other = (AssertionExpression)((Object)obj);
        if (this.condition == null ? other.condition != null : !this.condition.equals(other.condition)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return "AssertionExpression [name=" + this.name + ", condition=" + this.condition + ", preConditionsExpression=" + this.preConditionsExpression + "]";
    }
}

