/*
 * Decompiled with CFR 0.152.
 */
package org.streamingpool.ext.analysis.dsl;

import java.time.Duration;
import java.time.temporal.TemporalUnit;
import java.util.Objects;
import java.util.function.BiPredicate;
import org.streamingpool.core.service.StreamId;
import org.streamingpool.core.service.streamid.BufferSpecification;
import org.streamingpool.ext.tensorics.evaluation.BufferedEvaluation;

public class OngoingBufferedStrategyStarted<T> {
    private final BufferedEvaluation.Builder builder;

    public OngoingBufferedStrategyStarted(BufferedEvaluation.Builder builder) {
        this.builder = Objects.requireNonNull(builder, "builder must not be null");
    }

    public OngoingBufferedStrategyStarted<T> endedAfter(Duration timeout) {
        this.builder.withTimeout(timeout);
        return this;
    }

    public OngoingBufferedStrategyStarted<T> or() {
        return this;
    }

    public OngoingBufferedStrategyStarted<T> endedAfter(long time, TemporalUnit unit) {
        return this.endedAfter(Duration.of(time, unit));
    }

    public OngoingBufferedStrategyStarted<T> endedBy(StreamId<?> endStreamId) {
        this.builder.withEndMatcher(BufferSpecification.EndStreamMatcher.endingOnEvery(endStreamId));
        return this;
    }

    public <U> OngoingBufferedStrategyStarted<T> endedBy(StreamId<U> endStreamId, BiPredicate<T, U> predicate) {
        this.builder.withEndMatcher(BufferSpecification.EndStreamMatcher.endingOnMatch(endStreamId, predicate));
        return this;
    }
}

