/*
 * Decompiled with CFR 0.152.
 */
package org.streamingpool.ext.analysis;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.streamingpool.core.service.StreamId;
import org.streamingpool.core.service.streamid.BufferSpecification;
import org.streamingpool.core.service.streamid.OverlapBufferStreamId;
import org.streamingpool.ext.analysis.AssertionBuilder;
import org.streamingpool.ext.analysis.ConditionBuilder;
import org.streamingpool.ext.analysis.EnablingConditionBuilder;
import org.streamingpool.ext.analysis.dsl.OngoingAllBooleanCondition;
import org.streamingpool.ext.analysis.dsl.OngoingAllBooleanExcludableCondition;
import org.streamingpool.ext.analysis.dsl.OngoingAnalysisEnabler;
import org.streamingpool.ext.analysis.dsl.OngoingAnyBooleanCondition;
import org.streamingpool.ext.analysis.dsl.OngoingBooleanCondition;
import org.streamingpool.ext.analysis.dsl.OngoingBufferedStrategy;
import org.streamingpool.ext.analysis.dsl.OngoingCondition;
import org.streamingpool.ext.analysis.dsl.OngoingPrecondition;
import org.streamingpool.ext.analysis.dsl.OngoingTriggeredStrategy;
import org.streamingpool.ext.tensorics.evaluation.BufferedEvaluation;
import org.streamingpool.ext.tensorics.evaluation.ContinuousEvaluation;
import org.streamingpool.ext.tensorics.evaluation.EvaluationStrategy;
import org.streamingpool.ext.tensorics.evaluation.EvaluationStrategyBuilder;
import org.streamingpool.ext.tensorics.evaluation.TriggeredEvaluation;
import org.streamingpool.ext.tensorics.expression.StreamIdBasedExpression;
import org.streamingpool.ext.tensorics.streamid.ExpressionBasedStreamId;
import org.tensorics.core.tree.domain.Expression;
import org.tensorics.core.tree.domain.ResolvedExpression;

public abstract class AnalysisModule {
    private final List<AssertionBuilder> assertionBuilders = new ArrayList<AssertionBuilder>();
    private final AtomicBoolean enablingSpecified = new AtomicBoolean(false);
    private EnablingConditionBuilder enablerBuilder;
    private final AtomicBoolean strategySpecified = new AtomicBoolean(false);
    private EvaluationStrategyBuilder evaluationStrategyBuilder;
    private EvaluationStrategy evaluationStrategy = null;

    protected final OngoingAnalysisEnabler enabled() {
        this.throwIfEnablingSpecifiedTwice();
        this.newEnablerBuilder();
        return new OngoingAnalysisEnabler(this.enablerBuilder);
    }

    protected final OngoingTriggeredStrategy triggered() {
        this.throwIfStrategySpecifiedTwice();
        TriggeredEvaluation.Builder builder = TriggeredEvaluation.builder();
        this.evaluationStrategyBuilder = builder;
        return new OngoingTriggeredStrategy(builder);
    }

    protected final OngoingBufferedStrategy buffered() {
        this.throwIfStrategySpecifiedTwice();
        BufferedEvaluation.Builder builder = BufferedEvaluation.builder();
        this.evaluationStrategyBuilder = builder;
        return new OngoingBufferedStrategy(builder);
    }

    protected final <T> Expression<List<T>> buffered(Expression<T> sourceExpression) {
        Objects.requireNonNull(sourceExpression, "sourceExpression must not be null.");
        if (sourceExpression instanceof StreamIdBasedExpression) {
            return this.buffered(((StreamIdBasedExpression)sourceExpression).streamId());
        }
        return this.buffered((StreamId<T>)ExpressionBasedStreamId.of(sourceExpression));
    }

    protected final <T> Expression<? extends Iterable<T>> bufferedIterable(Expression<T> sourceExpression) {
        return this.buffered(sourceExpression);
    }

    protected final <T> Expression<? extends Iterable<T>> bufferedIterable(StreamId<T> sourceStream) {
        return this.buffered((Expression<T>)StreamIdBasedExpression.of(sourceStream));
    }

    protected final <T> Expression<List<T>> buffered(StreamId<T> sourceStreamId) {
        Objects.requireNonNull(sourceStreamId, "sourceStreamId must not be null.");
        if (sourceStreamId instanceof OverlapBufferStreamId) {
            throw new IllegalArgumentException("The given sourceStreamId is already a buffered stream id. Buffering a buffered stream makes limited sense and is currently not supported.");
        }
        return StreamIdBasedExpression.of((StreamId)OverlapBufferStreamId.of(sourceStreamId, (BufferSpecification)this.bufferSpecification()));
    }

    protected final <T> OngoingCondition<T> assertThat(Expression<T> thatSource) {
        return new OngoingCondition<T>(this.newAssertionBuilder(), thatSource);
    }

    protected final <T> OngoingCondition<T> assertThat(T thatSource) {
        return this.assertThat(ResolvedExpression.of(thatSource));
    }

    protected final <T> OngoingCondition<T> assertThat(StreamId<T> thatSource) {
        return this.assertThat(StreamIdBasedExpression.of(thatSource));
    }

    protected final OngoingBooleanCondition assertBoolean(Expression<Boolean> thatSource) {
        return new OngoingBooleanCondition((ConditionBuilder)this.newAssertionBuilder(), thatSource);
    }

    protected final OngoingBooleanCondition assertBoolean(Boolean thatSource) {
        return this.assertBoolean((Expression<Boolean>)ResolvedExpression.of((Object)thatSource));
    }

    protected final OngoingAllBooleanExcludableCondition assertAllBoolean(Set<? extends Expression<Boolean>> thatSource) {
        return new OngoingAllBooleanExcludableCondition(this.newAssertionBuilder(), thatSource);
    }

    protected final OngoingAllBooleanCondition assertAllBoolean(Expression<? extends Iterable<Boolean>> thatSource) {
        return new OngoingAllBooleanCondition(this.newAssertionBuilder(), thatSource);
    }

    protected final OngoingAllBooleanCondition assertAllBoolean(StreamId<? extends Iterable<Boolean>> thatSourceId) {
        return this.assertAllBoolean((Expression<? extends Iterable<Boolean>>)StreamIdBasedExpression.of(thatSourceId));
    }

    protected final OngoingAnyBooleanCondition assertAtLeastOneBooleanOf(Expression<? extends Iterable<Boolean>> thatSource) {
        return new OngoingAnyBooleanCondition(this.newAssertionBuilder(), thatSource);
    }

    protected final OngoingAnyBooleanCondition assertAtLeastOneBooleanOf(StreamId<? extends Iterable<Boolean>> thatSourceId) {
        return this.assertAtLeastOneBooleanOf((Expression<? extends Iterable<Boolean>>)StreamIdBasedExpression.of(thatSourceId));
    }

    protected final <T> OngoingPrecondition<T> when(Expression<T> whenSource) {
        return new OngoingPrecondition<Expression<T>>(this.newAssertionBuilder(), whenSource);
    }

    protected final <T> OngoingPrecondition<T> when(T whenSource) {
        return this.when(ResolvedExpression.of(whenSource));
    }

    private AssertionBuilder newAssertionBuilder() {
        AssertionBuilder builder = new AssertionBuilder();
        this.assertionBuilders.add(builder);
        return builder;
    }

    private void newEnablerBuilder() {
        this.enablerBuilder = new EnablingConditionBuilder();
    }

    public List<AssertionBuilder> assertionBuilders() {
        return this.assertionBuilders;
    }

    public EnablingConditionBuilder enablingBuilder() {
        return Optional.ofNullable(this.enablerBuilder).orElse(AnalysisModule.defaultEnablingConditionBuilder());
    }

    private EvaluationStrategyBuilder evaluationStrategyBuilder() {
        return Optional.ofNullable(this.evaluationStrategyBuilder).orElse(AnalysisModule.defaultEvaluationStrategyBuilder());
    }

    public EvaluationStrategy evaluationStrategy() {
        if (this.evaluationStrategy == null) {
            this.evaluationStrategy = this.evaluationStrategyBuilder().build();
        }
        return this.evaluationStrategy;
    }

    private void throwIfEnablingSpecifiedTwice() {
        if (this.enablingSpecified.getAndSet(true)) {
            throw new IllegalStateException("Only one fluent clause specifying the enabling condition is allowed. Seems you tried to call evaluated() twice.");
        }
    }

    private void throwIfStrategySpecifiedTwice() {
        if (this.strategySpecified.getAndSet(true)) {
            throw new IllegalStateException("It is only allowed to specify once either triggered() or buffered() within the same analysis module. It seems that you tried to specify both or one twice.");
        }
    }

    private BufferSpecification bufferSpecification() {
        EvaluationStrategy strategy = this.evaluationStrategy();
        if (!(strategy instanceof BufferedEvaluation)) {
            throw new IllegalStateException("The usage of buffered values is only allowed while using the '" + BufferedEvaluation.class.getSimpleName() + "' evaluation strategy. Probably you forgot to specify the buffered()... clause? (This has to be done before using a buffered stream/expression)");
        }
        return ((BufferedEvaluation)strategy).bufferSpecification();
    }

    private static final EnablingConditionBuilder defaultEnablingConditionBuilder() {
        return (EnablingConditionBuilder)new EnablingConditionBuilder().withCondition((Expression<Boolean>)ResolvedExpression.of((Object)true));
    }

    private static final EvaluationStrategyBuilder defaultEvaluationStrategyBuilder() {
        return ContinuousEvaluation.builder();
    }
}

