/*
 * Decompiled with CFR 0.152.
 */
package org.streamingpool.ext.analysis.dsl;

import java.util.Objects;
import java.util.Set;
import org.streamingpool.ext.analysis.AssertionBuilder;
import org.streamingpool.ext.analysis.ConditionBuilder;
import org.streamingpool.ext.analysis.dsl.AnyOf;
import org.streamingpool.ext.analysis.dsl.OngoingAllBooleanExcludableCondition;
import org.streamingpool.ext.analysis.dsl.OngoingAnyBooleanCondition;
import org.streamingpool.ext.analysis.dsl.OngoingBooleanCondition;
import org.streamingpool.ext.analysis.dsl.OngoingCondition;
import org.tensorics.core.tree.domain.Expression;
import org.tensorics.core.tree.domain.ResolvedExpression;
import org.tensorics.expression.IsEqualToExpression;

public class OngoingPrecondition<T> {
    private final AssertionBuilder builder;
    private final Expression<T> source;

    public OngoingPrecondition(AssertionBuilder builder, Expression<T> whenSource) {
        this.builder = Objects.requireNonNull(builder, "builder must not be null");
        this.source = Objects.requireNonNull(whenSource, "source must not be null");
    }

    public OngoingPrecondition(AssertionBuilder builder, T source) {
        this(builder, ResolvedExpression.of(source));
    }

    public OngoingPrecondition<T> isEqualTo(Expression<T> other) {
        this.builder.withPreCondition((Expression<Boolean>)new IsEqualToExpression(this.source, other));
        return this;
    }

    public OngoingPrecondition<T> isEqualTo(T other) {
        return this.isEqualTo(ResolvedExpression.of(other));
    }

    public OngoingPrecondition<T> or() {
        this.builder.withPreConditionReducer(new AnyOf());
        return this;
    }

    public final <T1> OngoingCondition<T1> thenAssertThat(Expression<T1> thatSource) {
        return new OngoingCondition<T1>(this.builder, thatSource);
    }

    public final <T1> OngoingCondition<T1> thenAssertThat(T1 thatSource) {
        return this.thenAssertThat(ResolvedExpression.of(thatSource));
    }

    public final OngoingBooleanCondition thenAssertBoolean(Expression<Boolean> thatSource) {
        return new OngoingBooleanCondition((ConditionBuilder)this.builder, thatSource);
    }

    public final OngoingAllBooleanExcludableCondition thenAssertAllBoolean(Set<? extends Expression<Boolean>> thatSource) {
        return new OngoingAllBooleanExcludableCondition(this.builder, thatSource);
    }

    public final OngoingAnyBooleanCondition thenAssertAtLeastOneBooleanOf(Expression<? extends Iterable<Boolean>> thatSource) {
        return new OngoingAnyBooleanCondition(this.builder, thatSource);
    }

    public final OngoingBooleanCondition thenAssertBoolean(Boolean thatSource) {
        return this.thenAssertBoolean((Expression<Boolean>)ResolvedExpression.of((Object)thatSource));
    }
}

