/*
 * Decompiled with CFR 0.152.
 */
package org.streamingpool.ext.analysis.repr;

import com.google.common.collect.Streams;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.streamingpool.core.service.streamid.DerivedStreamId;
import org.streamingpool.core.service.streamid.OverlapBufferStreamId;
import org.streamingpool.ext.tensorics.expression.BufferedStreamExpression;
import org.streamingpool.ext.tensorics.expression.UnresolvedStreamIdBasedExpression;
import org.streamingpool.ext.tensorics.streamid.ExpressionBasedStreamId;
import org.tensorics.core.analysis.expression.AnalysisExpression;
import org.tensorics.core.analysis.expression.AssertionExpression;
import org.tensorics.core.expressions.BinaryPredicateExpression;
import org.tensorics.core.expressions.ConversionOperationExpression;
import org.tensorics.core.expressions.LatestOfExpression;
import org.tensorics.core.functional.expressions.FunctionalExpression;
import org.tensorics.core.tree.domain.ResolvedExpression;
import org.tensorics.core.util.chains.AbstractRecursiveRepresenter;

public class ExpressionTreeFormulaCaseMatching
extends AbstractRecursiveRepresenter<String> {
    private final Function<Object, String> strictNaming;

    public ExpressionTreeFormulaCaseMatching(Function<Object, String> strictNaming) {
        this.strictNaming = strictNaming;
    }

    public String repr(Iterable<?> iterable) {
        return "[" + Streams.stream(iterable).map(arg_0 -> ((ExpressionTreeFormulaCaseMatching)this).recurse(arg_0)).collect(Collectors.joining(",")) + "]";
    }

    public String repr(FunctionalExpression<?> exp) {
        return this.strictNaming.apply(exp);
    }

    public String repr(LatestOfExpression<?> exp) {
        return "latestOf(" + (String)this.recurse(exp.iterableExpression()) + ")";
    }

    public String repr(AnalysisExpression ag) {
        return "AssertionGroup: " + (String)this.recurse(ag.getChildren());
    }

    public String repr(AssertionExpression ae) {
        return "assertThat(" + (String)this.recurse(ae.condition()) + ")";
    }

    public String repr(BinaryPredicateExpression<?> exp) {
        String operatorName = exp.getPredicate().getClass().getSimpleName();
        return (String)this.recurse(exp.getLeft()) + " " + operatorName + " " + (String)this.recurse(exp.getRight());
    }

    public String repr(ResolvedExpression<?> exp) {
        return exp.get() == null ? "Null" : exp.get().toString();
    }

    public String repr(ConversionOperationExpression<?, ?> exp) {
        return (String)this.recurse(exp.getOperation()) + "(" + (String)this.recurse(exp.getSource()) + ")";
    }

    public String repr(UnresolvedStreamIdBasedExpression<?> exp) {
        return (String)this.recurse(exp.streamIdExpression());
    }

    public String repr(BufferedStreamExpression<?> exp) {
        return (String)this.recurse(exp.streamIdExpression());
    }

    public String repr(OverlapBufferStreamId<?> id) {
        return (String)this.recurse(id.sourceId());
    }

    public String repr(ExpressionBasedStreamId<?> id) {
        return (String)this.recurse(id.expression());
    }

    public String repr(DerivedStreamId<?, ?> id) {
        return (String)this.recurse(id.conversion()) + "(" + (String)this.recurse(id.sourceStreamId()) + ")";
    }
}

