/*
 * Decompiled with CFR 0.152.
 */
package org.streamingpool.ext.analysis.testing;

import io.reactivex.subscribers.TestSubscriber;
import java.util.List;
import java.util.stream.Collectors;
import org.streamingpool.ext.analysis.support.RxAnalysisSupport;
import org.streamingpool.ext.analysis.testing.AnalysisTest;
import org.tensorics.core.analysis.AnalysisResult;
import org.tensorics.core.analysis.AssertionStatus;
import org.tensorics.core.analysis.expression.AnalysisExpression;
import org.tensorics.core.analysis.expression.AssertionExpression;
import org.tensorics.core.resolve.domain.DetailedExpressionResult;

public interface RxAnalysisTestingSupport
extends AnalysisTest,
RxAnalysisSupport {
    default public List<AssertionStatus> evaluationStatusesOf(TestSubscriber<DetailedExpressionResult<AnalysisResult, AnalysisExpression>> subscriber) {
        return subscriber.values().stream().map(r -> ((AnalysisResult)r.value()).overallStatus()).collect(Collectors.toList());
    }

    default public List<AssertionStatus> assertionsStatusesOf(TestSubscriber<AnalysisResult> subscriber) {
        return subscriber.values().stream().map(result -> result.overallStatus()).collect(Collectors.toList());
    }

    default public List<AssertionStatus> statusesOfAssertion(TestSubscriber<AnalysisResult> subscriber, String name) {
        return subscriber.values().stream().map(detailedResult -> this.statusOfAssertion((AnalysisResult)detailedResult, name)).collect(Collectors.toList());
    }

    default public AssertionStatus statusOfAssertion(DetailedExpressionResult<AnalysisResult, AnalysisExpression> result, String name) {
        return this.statusOfAssertion((AnalysisResult)result.value(), name);
    }

    default public AssertionStatus statusOfAssertion(AnalysisResult result, String name) {
        List assertionsWithName = result.assertions().stream().filter(assertion -> assertion.name().equals(name)).collect(Collectors.toList());
        if (assertionsWithName.size() != 1) {
            throw new IllegalArgumentException(String.format("%s assertions match the name %s. Name should be unique", assertionsWithName.size(), name));
        }
        return result.statusFor((AssertionExpression)assertionsWithName.get(0));
    }
}

