/*
 * Decompiled with CFR 0.152.
 */
package cern.streaming.pool.ext.tensorics.evaluation;

import cern.streaming.pool.core.service.StreamId;
import cern.streaming.pool.ext.tensorics.evaluation.EvaluationStrategy;
import cern.streaming.pool.ext.tensorics.evaluation.EvaluationStrategyBuilder;
import java.util.Objects;

public class TriggeredEvaluation
implements EvaluationStrategy {
    private final StreamId<?> triggeringStreamId;

    private TriggeredEvaluation(StreamId<?> triggeringStreamId) {
        this.triggeringStreamId = Objects.requireNonNull(triggeringStreamId, "triggeringStreamId must not be null");
    }

    public static TriggeredEvaluation triggeredBy(StreamId<?> triggeringStreamId) {
        return new TriggeredEvaluation(triggeringStreamId);
    }

    public StreamId<?> triggeringStreamId() {
        return this.triggeringStreamId;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends EvaluationStrategyBuilder {
        private StreamId<?> triggeringStreamId;

        public Builder withTriggeringStreamId(StreamId<?> newTriggeringStreamId) {
            this.triggeringStreamId = newTriggeringStreamId;
            return this;
        }

        @Override
        public EvaluationStrategy build() {
            return TriggeredEvaluation.triggeredBy(this.triggeringStreamId);
        }
    }
}

