/*
 * Decompiled with CFR 0.152.
 */
package org.streamingpool.ext.tensorics.evaluation;

import java.util.Objects;
import org.streamingpool.core.service.StreamId;
import org.streamingpool.ext.tensorics.evaluation.EvaluationStrategy;
import org.streamingpool.ext.tensorics.evaluation.EvaluationStrategyBuilder;

public class TriggeredEvaluation
implements EvaluationStrategy {
    private final StreamId<?> triggeringStreamId;

    private TriggeredEvaluation(StreamId<?> triggeringStreamId) {
        this.triggeringStreamId = Objects.requireNonNull(triggeringStreamId, "triggeringStreamId must not be null");
    }

    public static TriggeredEvaluation triggeredBy(StreamId<?> triggeringStreamId) {
        return new TriggeredEvaluation(triggeringStreamId);
    }

    public StreamId<?> triggeringStreamId() {
        return this.triggeringStreamId;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends EvaluationStrategyBuilder {
        private StreamId<?> triggeringStreamId;

        public Builder withTriggeringStreamId(StreamId<?> newTriggeringStreamId) {
            this.triggeringStreamId = newTriggeringStreamId;
            return this;
        }

        @Override
        public EvaluationStrategy build() {
            return TriggeredEvaluation.triggeredBy(this.triggeringStreamId);
        }
    }
}

