/*
 * Decompiled with CFR 0.152.
 */
package org.streamingpool.ext.tensorics.evaluation;

import java.time.Duration;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.streamingpool.core.service.StreamId;
import org.streamingpool.core.service.streamid.BufferSpecification;
import org.streamingpool.ext.tensorics.evaluation.EvaluationStrategy;
import org.streamingpool.ext.tensorics.evaluation.EvaluationStrategyBuilder;

public class BufferedEvaluation
implements EvaluationStrategy {
    private final BufferSpecification bufferSpecification;

    private BufferedEvaluation(BufferSpecification bufferSpecification) {
        this.bufferSpecification = Objects.requireNonNull(bufferSpecification, "bufferSpecification must not be null");
    }

    public BufferSpecification bufferSpecification() {
        return this.bufferSpecification;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends EvaluationStrategyBuilder {
        private StreamId<?> startStreamId;
        private Set<BufferSpecification.EndStreamMatcher<?, ?>> endStreamsMatchers = new HashSet();
        private Duration timeout = null;

        public Builder withStartStreamId(StreamId<?> newStartStreamId) {
            this.startStreamId = newStartStreamId;
            return this;
        }

        public Builder withEndMatcher(BufferSpecification.EndStreamMatcher<?, ?> endMatcher) {
            this.endStreamsMatchers.add(endMatcher);
            return this;
        }

        public Builder withTimeout(Duration newTimeout) {
            this.timeout = newTimeout;
            return this;
        }

        @Override
        public EvaluationStrategy build() {
            if (this.timeout == null) {
                return new BufferedEvaluation(BufferSpecification.ofStartEnd(this.startStreamId, this.endStreamsMatchers));
            }
            return new BufferedEvaluation(BufferSpecification.ofStartEndTimeout(this.startStreamId, this.endStreamsMatchers, (Duration)this.timeout));
        }
    }
}

