/*
 * Decompiled with CFR 0.152.
 */
package org.streamingpool.ext.tensorics.streamfactory;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import io.reactivex.Flowable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.streamingpool.core.domain.ErrorDeflector;
import org.streamingpool.core.domain.ErrorStreamPair;
import org.streamingpool.core.service.DiscoveryService;
import org.streamingpool.core.service.StreamFactory;
import org.streamingpool.core.service.StreamId;
import org.streamingpool.core.service.streamid.BufferSpecification;
import org.streamingpool.core.service.streamid.OverlapBufferStreamId;
import org.streamingpool.ext.tensorics.evaluation.BufferedEvaluation;
import org.streamingpool.ext.tensorics.evaluation.EvaluationStrategy;
import org.streamingpool.ext.tensorics.expression.BufferedStreamExpression;
import org.streamingpool.ext.tensorics.streamid.DetailedExpressionStreamId;
import org.tensorics.core.expressions.Placeholder;
import org.tensorics.core.resolve.engine.ResolvedContextDidNotGrowException;
import org.tensorics.core.resolve.engine.ResolvingEngine;
import org.tensorics.core.resolve.options.HandleWithFirstCapableAncestorStrategy;
import org.tensorics.core.resolve.options.ResolvingOption;
import org.tensorics.core.tree.domain.Contexts;
import org.tensorics.core.tree.domain.EditableResolvingContext;
import org.tensorics.core.tree.domain.Expression;
import org.tensorics.core.tree.domain.ResolvingContext;
import org.tensorics.core.tree.walking.EveryNodeCallback;
import org.tensorics.core.tree.walking.NodeCallback;
import org.tensorics.core.tree.walking.Trees;

public class BufferedTensoricsExpressionStreamFactory
implements StreamFactory {
    private static final HandleWithFirstCapableAncestorStrategy EXCEPTION_HANDLING_STRATEGY = new HandleWithFirstCapableAncestorStrategy();
    private final ResolvingEngine engine;

    public BufferedTensoricsExpressionStreamFactory(ResolvingEngine engine) {
        this.engine = engine;
    }

    public <T> ErrorStreamPair<T> create(StreamId<T> id, DiscoveryService discovery) {
        Flowable resultStream;
        if (!(id instanceof DetailedExpressionStreamId)) {
            return ErrorStreamPair.empty();
        }
        DetailedExpressionStreamId expressionStreamId = (DetailedExpressionStreamId)id;
        EvaluationStrategy evaluationStrategy = BufferedTensoricsExpressionStreamFactory.evaluationStrategy(expressionStreamId);
        if (!(evaluationStrategy instanceof BufferedEvaluation)) {
            return ErrorStreamPair.empty();
        }
        BufferSpecification bufferSpecification = ((BufferedEvaluation)evaluationStrategy).bufferSpecification();
        Object rootExpression = expressionStreamId.expression();
        ResolvingContext initialCtx = expressionStreamId.initialContext();
        List<BufferedStreamExpression<?>> bufferedStreamExpressions = BufferedTensoricsExpressionStreamFactory.allBufferedStreamExpressions(rootExpression);
        Multimap<StreamId<?>, BufferedStreamExpression<?>> streamIdToExpressions = this.streamIdToExpressions(bufferedStreamExpressions, initialCtx);
        Set streamIds = streamIdToExpressions.keySet();
        Set<OverlapBufferStreamId<?>> bufferedStreamIds = BufferedTensoricsExpressionStreamFactory.bufferdStreamIds(streamIds, bufferSpecification);
        Set<Flowable<IdentifiedValue>> bufferedFlowables = BufferedTensoricsExpressionStreamFactory.discoverIdentifiedStreams(discovery, bufferedStreamIds);
        ErrorDeflector ed = ErrorDeflector.create();
        Flowable castedResultStream = resultStream = Flowable.zip(bufferedFlowables, zipValues -> {
            EditableResolvingContext bufferedValuesCtx = Contexts.newResolvingContext();
            for (Object zipValue : zipValues) {
                IdentifiedValue identifiedValue = (IdentifiedValue)zipValue;
                OverlapBufferStreamId streamId = (OverlapBufferStreamId)identifiedValue.streamId;
                Object bufferValue = identifiedValue.value;
                Collection expressionsUsingStreamId = streamIdToExpressions.get((Object)streamId.sourceId());
                expressionsUsingStreamId.forEach(expr -> bufferedValuesCtx.put((Expression)expr, bufferValue));
            }
            return bufferedValuesCtx;
        }).map(bufferedValuesCtx -> {
            EditableResolvingContext fullCtx = Contexts.newResolvingContext();
            EditableResolvingContext castedResolvingCtx = bufferedValuesCtx;
            fullCtx.putAllNew((ResolvingContext)castedResolvingCtx);
            fullCtx.putAllNew(initialCtx);
            return fullCtx;
        }).map(ed.emptyOnException(fullCtx -> this.engine.resolveDetailed(rootExpression, fullCtx, new ResolvingOption[]{EXCEPTION_HANDLING_STRATEGY}))).share();
        return ed.streamNonEmpty((Publisher)castedResultStream);
    }

    private static Set<Flowable<IdentifiedValue>> discoverIdentifiedStreams(DiscoveryService discoveryService, Set<OverlapBufferStreamId<?>> bufferedStreamIds) {
        return bufferedStreamIds.stream().map(streamId -> {
            Flowable stream = Flowable.fromPublisher((Publisher)discoveryService.discover((StreamId)streamId));
            return stream.map(value -> new IdentifiedValue((StreamId<?>)streamId, value));
        }).collect(Collectors.toSet());
    }

    private static Set<OverlapBufferStreamId<?>> bufferdStreamIds(Set<StreamId<?>> streamIds, BufferSpecification bufferSpecification) {
        return streamIds.stream().map(si -> OverlapBufferStreamId.of((StreamId)si, (BufferSpecification)bufferSpecification)).collect(Collectors.toSet());
    }

    @VisibleForTesting
    Multimap<StreamId<?>, BufferedStreamExpression<?>> streamIdToExpressions(List<BufferedStreamExpression<?>> bufferedStreamExpressions, ResolvingContext ctx) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        for (BufferedStreamExpression<?> bufferedStreamExpression : bufferedStreamExpressions) {
            StreamId<?> streamId = this.resolveStreamIdExpression(bufferedStreamExpression, ctx);
            builder.put(streamId, bufferedStreamExpression);
        }
        return builder.build();
    }

    private StreamId<?> resolveStreamIdExpression(BufferedStreamExpression<?> bufferedExpr, ResolvingContext ctx) {
        Expression<StreamId<?>> streamIdExpression = bufferedExpr.streamIdExpression();
        try {
            return (StreamId)this.engine.resolve(streamIdExpression, ctx, new ResolvingOption[0]);
        }
        catch (ResolvedContextDidNotGrowException exc) {
            throw new RuntimeException(String.format("Cannot resolve streamid expression %s of buffered expression %s", new Object[]{streamIdExpression, bufferedExpr}), exc);
        }
    }

    @VisibleForTesting
    static List<BufferedStreamExpression<?>> allBufferedStreamExpressions(Expression<?> rootExpression) {
        LinkedList bufferedExpressions = new LinkedList();
        EveryNodeCallback callback = node -> {
            if (node instanceof BufferedStreamExpression) {
                bufferedExpressions.add((BufferedStreamExpression)node);
            }
        };
        Trees.walkParentAfterChildren(rootExpression, (NodeCallback)callback);
        if (bufferedExpressions.isEmpty()) {
            throw new IllegalArgumentException("The specified root expression does not contain any BufferedStreamExpression: " + rootExpression);
        }
        return bufferedExpressions;
    }

    private static EvaluationStrategy evaluationStrategy(DetailedExpressionStreamId<?, ?> expressionStreamId) {
        Placeholder placeholder = Placeholder.ofClass(EvaluationStrategy.class);
        if (!expressionStreamId.initialContext().resolves((Expression)placeholder)) {
            throw new IllegalStateException("Initial context must provide a value for the placeholder of an EvaluationStrategy");
        }
        return (EvaluationStrategy)expressionStreamId.initialContext().resolvedValueOf((Expression)placeholder);
    }

    private static class IdentifiedValue {
        private final StreamId<?> streamId;
        private final Object value;

        public IdentifiedValue(StreamId<?> streamId, Object value) {
            this.streamId = streamId;
            this.value = value;
        }

        public String toString() {
            return "IdentifiedValue [streamId=" + this.streamId + ", value=" + this.value + "]";
        }
    }
}

