/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.backend;

import io.swagger.v3.jaxrs2.integration.OpenApiServlet;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PreDestroy;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletContextListener;
import org.apache.shiro.web.env.EnvironmentLoaderListener;
import org.apache.shiro.web.servlet.ShiroFilter;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletListenerRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.streampipes.app.file.export.application.AppFileExportApplication;
import org.streampipes.manager.operations.Operations;
import org.streampipes.rest.notifications.NotificationListener;

@SpringBootApplication
public class StreamPipesBackendApplication {
    private static final Logger LOG = LoggerFactory.getLogger((String)StreamPipesBackendApplication.class.getCanonicalName());

    public static void main(String[] args) {
        System.setProperty("org.apache.tomcat.util.buf.UDecoder.ALLOW_ENCODED_SLASH", "true");
        SpringApplication.run(StreamPipesBackendApplication.class, (String[])args);
    }

    @PreDestroy
    public void onExit() {
        LOG.info("Shutting down StreamPipes...");
        List status = Operations.stopAllPipelines();
        status.forEach(s -> {
            if (s.isSuccess()) {
                LOG.info("Pipeline {} successfully stopped", (Object)s.getPipelineName());
            } else {
                LOG.error("Pipeline {} could not be stopped", (Object)s.getPipelineName());
            }
        });
    }

    @Bean
    public ServletRegistrationBean appFileExportRegistrationBean() {
        ServletContainer jerseyContainer = new ServletContainer((ResourceConfig)new AppFileExportApplication());
        return new ServletRegistrationBean((Servlet)jerseyContainer, new String[]{"/api/apps/*"});
    }

    @Bean
    public ServletRegistrationBean swaggerRegistrationBean() {
        ServletRegistrationBean bean = new ServletRegistrationBean((Servlet)new OpenApiServlet(), new String[]{"/api/docs/*"});
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("openApi.configuration.resourcePackages", "io.swagger.sample.resource");
        bean.setInitParameters(params);
        return bean;
    }

    @Bean
    public FilterRegistrationBean shiroFilterBean() {
        FilterRegistrationBean bean = new FilterRegistrationBean();
        bean.setFilter((Filter)new ShiroFilter());
        bean.addUrlPatterns(new String[]{"/api/*"});
        return bean;
    }

    @Bean
    public ServletListenerRegistrationBean shiroListenerBean() {
        return this.listener((ServletContextListener)new EnvironmentLoaderListener());
    }

    @Bean
    public ServletListenerRegistrationBean streamPipesNotificationListenerBean() {
        return this.listener((ServletContextListener)new NotificationListener());
    }

    private ServletListenerRegistrationBean listener(ServletContextListener listener) {
        ServletListenerRegistrationBean bean = new ServletListenerRegistrationBean();
        bean.setListener((EventListener)listener);
        return bean;
    }
}

