/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.config.backend;

import org.streampipes.config.SpConfig;

public enum BackendConfig {
    INSTANCE;

    private SpConfig config = SpConfig.getSpConfig("backend");
    private static final String BACKEND_HOST = "backend_host";
    private static final String BACKEND_PORT = "backend_port";
    private static final String JMS_HOST = "jms_host";
    private static final String JMS_PORT = "jms_port";
    private static final String KAFKA_HOST = "kafka_host";
    private static final String KAFKA_PORT = "kafka_port";
    private static final String ZOOKEEPER_HOST = "zookeeper_host";
    private static final String ZOOKEEPER_PORT = "zookeeper_port";
    private static final String ELASTICSEARCH_HOST = "elasticsearch_host";
    private static final String ELASTICSEARCH_PORT = "elasticsearch_port";
    private static final String ELASTICSEARCH_PROTOCOL = "elasticsearch_protocol";
    private static final String IS_CONFIGURED = "is_configured";
    private static final String KAFKA_REST_HOST = "kafka_rest_host";
    private static final String KAFKA_REST_PORT = "kafka_rest_port";

    private BackendConfig() {
        this.config.register(BACKEND_HOST, "backend", "Hostname for backend");
        this.config.register(BACKEND_PORT, 8082, "Port for backend");
        this.config.register(JMS_HOST, "activemq", "Hostname for backend service for active mq");
        this.config.register(JMS_PORT, 61616, "Port for backend service for active mq");
        this.config.register(KAFKA_HOST, "kafka", "Hostname for backend service for kafka");
        this.config.register(KAFKA_PORT, 9092, "Port for backend service for kafka");
        this.config.register(ZOOKEEPER_HOST, "zookeeper", "Hostname for backend service for zookeeper");
        this.config.register(ZOOKEEPER_PORT, 2181, "Port for backend service for zookeeper");
        this.config.register(ELASTICSEARCH_HOST, "elasticsearch", "Hostname for elasticsearch service");
        this.config.register(ELASTICSEARCH_PORT, 9200, "Port for elasticsearch service");
        this.config.register(ELASTICSEARCH_PROTOCOL, "http", "Protocol the elasticsearch service");
        this.config.register(IS_CONFIGURED, false, "Boolean that indicates whether streampipes is already configured or not");
        this.config.register(KAFKA_REST_HOST, "kafka-rest", "The hostname of the kafka-rest module");
        this.config.register(KAFKA_REST_PORT, 8073, "The port of the kafka-rest module");
    }

    public String getBackendHost() {
        return this.config.getString(BACKEND_HOST);
    }

    public int getBackendPort() {
        return this.config.getInteger(BACKEND_PORT);
    }

    public String getJmsHost() {
        return this.config.getString(JMS_HOST);
    }

    public int getJmsPort() {
        return this.config.getInteger(JMS_PORT);
    }

    public String getKafkaHost() {
        return this.config.getString(KAFKA_HOST);
    }

    public int getKafkaPort() {
        return this.config.getInteger(KAFKA_PORT);
    }

    public String getKafkaUrl() {
        return this.getKafkaHost() + ":" + this.getKafkaPort();
    }

    public String getZookeeperHost() {
        return this.config.getString(ZOOKEEPER_HOST);
    }

    public int getZookeeperPort() {
        return this.config.getInteger(ZOOKEEPER_PORT);
    }

    public boolean isConfigured() {
        return this.config.getBoolean(IS_CONFIGURED);
    }

    public void setKafkaHost(String s) {
        this.config.setString(KAFKA_HOST, s);
    }

    public void setZookeeperHost(String s) {
        this.config.setString(ZOOKEEPER_HOST, s);
    }

    public void setJmsHost(String s) {
        this.config.setString(JMS_HOST, s);
    }

    public void setIsConfigured(boolean b) {
        this.config.setBoolean(IS_CONFIGURED, b);
    }

    public String getElasticsearchHost() {
        return this.config.getString(ELASTICSEARCH_HOST);
    }

    public int getElasticsearchPort() {
        return this.config.getInteger(ELASTICSEARCH_PORT);
    }

    public String getElasticsearchProtocol() {
        return this.config.getString(ELASTICSEARCH_PROTOCOL);
    }

    public String getElasticsearchURL() {
        return this.getElasticsearchProtocol() + "://" + this.getElasticsearchHost() + ":" + this.getElasticsearchPort();
    }

    public String getKafkaRestHost() {
        return this.config.getString(KAFKA_REST_HOST);
    }

    public Integer getKafkaRestPort() {
        return this.config.getInteger(KAFKA_REST_PORT);
    }

    public String getKafkaRestUrl() {
        return "http://" + this.getKafkaRestHost() + ":" + this.getKafkaRestPort();
    }
}

