/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.config.consul;

import com.orbitz.consul.Consul;
import com.orbitz.consul.KeyValueClient;
import com.orbitz.consul.model.kv.Value;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.streampipes.config.SpConfig;
import org.streampipes.config.SpConfigChangeCallback;

public class ConsulSpConfig
extends SpConfig
implements Runnable {
    private static final String CONSUL_ENV_LOCATION = "CONSUL_LOCATION";
    public static final String SERVICE_ROUTE_PREFIX = "sp/v1/";
    private String serviceName;
    private KeyValueClient kvClient;
    private SpConfigChangeCallback callback;
    private Map<String, Object> configProps;

    public ConsulSpConfig(String serviceName) {
        super(serviceName);
        Consul consul;
        Map<String, String> env = System.getenv();
        if (env.containsKey(CONSUL_ENV_LOCATION)) {
            URL url = null;
            try {
                url = new URL("http", env.get(CONSUL_ENV_LOCATION), 8500, "");
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            consul = Consul.builder().withUrl(url).build();
        } else {
            consul = Consul.builder().build();
        }
        this.kvClient = consul.keyValueClient();
        this.serviceName = serviceName;
    }

    public ConsulSpConfig(String serviceName, SpConfigChangeCallback callback) {
        this(serviceName);
        this.callback = callback;
        this.configProps = new HashMap<String, Object>();
        new Thread(this).start();
    }

    @Override
    public void run() {
        Consul consulThread = Consul.builder().build();
        KeyValueClient kvClientThread = consulThread.keyValueClient();
        while (true) {
            this.configProps.keySet().stream().forEach(s -> {
                Optional te = kvClientThread.getValue(this.addSn((String)s));
                if (!((String)((Value)te.get()).getValueAsString().get()).equals(this.configProps.get(s))) {
                    this.callback.onChange();
                    this.configProps.put((String)s, ((Value)te.get()).getValueAsString().get());
                }
            });
            try {
                Thread.sleep(10000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    @Override
    public void register(String key, boolean defaultValue, String description) {
        this.register(key, Boolean.toString(defaultValue), "xs:boolean", description, false);
    }

    @Override
    public void register(String key, int defaultValue, String description) {
        this.register(key, Integer.toString(defaultValue), "xs:integer", description, false);
    }

    @Override
    public void register(String key, double defaultValue, String description) {
        this.register(key, Double.toString(defaultValue), "xs:double", description, false);
    }

    @Override
    public void register(String key, String defaultValue, String description) {
        this.register(key, defaultValue, "xs:string", description, false);
    }

    @Override
    public void registerPassword(String key, String defaultValue, String description) {
        this.register(key, defaultValue, "xs:string", description, true);
    }

    private void register(String key, String defaultValue, String valueType, String description, boolean isPassword) {
        Optional i = this.kvClient.getValueAsString(this.addSn(key));
        if (!i.isPresent()) {
            String envVariable = System.getenv(key);
            if (envVariable != null) {
                this.kvClient.putValue(this.addSn(key), envVariable);
            } else {
                this.kvClient.putValue(this.addSn(key), defaultValue);
            }
            this.kvClient.putValue(this.addSn(key) + "_description", description);
            this.kvClient.putValue(this.addSn(key) + "_type", valueType);
            if (isPassword) {
                this.kvClient.putValue(this.addSn(key) + "_isPassword", "true");
            }
        }
        if (this.configProps != null) {
            this.configProps.put(key, this.getString(key));
        }
    }

    @Override
    public boolean getBoolean(String key) {
        return Boolean.parseBoolean(this.getString(key));
    }

    @Override
    public int getInteger(String key) {
        return Integer.parseInt(this.getString(key));
    }

    @Override
    public double getDouble(String key) {
        return Double.parseDouble(this.getString(key));
    }

    @Override
    public String getString(String key) {
        Optional os = this.kvClient.getValueAsString(this.addSn(key));
        String s = (String)os.get();
        return s;
    }

    @Override
    public void setBoolean(String key, Boolean value) {
        this.setString(key, value.toString());
    }

    @Override
    public void setInteger(String key, int value) {
        this.setString(key, String.valueOf(value));
    }

    @Override
    public void setDouble(String key, double value) {
        this.setString(key, String.valueOf(value));
    }

    @Override
    public void setString(String key, String value) {
        this.kvClient.putValue(this.addSn(key), value);
    }

    private String addSn(String key) {
        return SERVICE_ROUTE_PREFIX + this.serviceName + "/" + key;
    }
}

