/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.config.consul;

import com.google.gson.Gson;
import com.orbitz.consul.Consul;
import com.orbitz.consul.KeyValueClient;
import com.orbitz.consul.model.kv.Value;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.streampipes.config.SpConfig;
import org.streampipes.config.SpConfigChangeCallback;
import org.streampipes.config.model.ConfigItem;
import org.streampipes.config.model.ConfigurationScope;

public class ConsulSpConfig
extends SpConfig
implements Runnable {
    private static final String CONSUL_ENV_LOCATION = "CONSUL_LOCATION";
    public static final String SERVICE_ROUTE_PREFIX = "sp/v1/";
    private String serviceName;
    private KeyValueClient kvClient;
    private SpConfigChangeCallback callback;
    private Map<String, Object> configProps;

    public ConsulSpConfig(String serviceName) {
        super(serviceName);
        Consul consul;
        Map<String, String> env = System.getenv();
        if (env.containsKey(CONSUL_ENV_LOCATION)) {
            URL url = null;
            try {
                url = new URL("http", env.get(CONSUL_ENV_LOCATION), 8500, "");
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            consul = Consul.builder().withUrl(url).build();
        } else {
            consul = Consul.builder().build();
        }
        this.kvClient = consul.keyValueClient();
        this.serviceName = serviceName;
    }

    public ConsulSpConfig(String serviceName, SpConfigChangeCallback callback) {
        this(serviceName);
        this.callback = callback;
        this.configProps = new HashMap<String, Object>();
        new Thread(this).start();
    }

    @Override
    public void run() {
        Consul consulThread = Consul.builder().build();
        KeyValueClient kvClientThread = consulThread.keyValueClient();
        while (true) {
            this.configProps.keySet().forEach(s -> {
                Optional te = kvClientThread.getValue(this.addSn((String)s));
                if (!((String)((Value)te.get()).getValueAsString().get()).equals(this.configProps.get(s))) {
                    this.callback.onChange();
                    this.configProps.put((String)s, ((Value)te.get()).getValueAsString().get());
                }
            });
            try {
                Thread.sleep(10000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    @Override
    public <T> void register(String key, T defaultValue, String description, ConfigurationScope configurationScope) {
        this.register(key, String.valueOf(defaultValue), this.getValueType(defaultValue), description, configurationScope, false);
    }

    private <T> String getValueType(T defaultValue) {
        if (defaultValue instanceof Boolean) {
            return "xs:boolean";
        }
        if (defaultValue instanceof Integer) {
            return "xs:integer";
        }
        if (defaultValue instanceof Double) {
            return "xs:double";
        }
        return "xs:string";
    }

    @Override
    public void register(String key, boolean defaultValue, String description) {
        this.register(key, Boolean.toString(defaultValue), "xs:boolean", description, ConfigurationScope.CONTAINER_STARTUP_CONFIG, false);
    }

    @Override
    public void register(String key, int defaultValue, String description) {
        this.register(key, Integer.toString(defaultValue), "xs:integer", description, ConfigurationScope.CONTAINER_STARTUP_CONFIG, false);
    }

    @Override
    public void register(String key, double defaultValue, String description) {
        this.register(key, Double.toString(defaultValue), "xs:double", description, ConfigurationScope.CONTAINER_STARTUP_CONFIG, false);
    }

    @Override
    public void register(String key, String defaultValue, String description) {
        this.register(key, defaultValue, "xs:string", description, ConfigurationScope.CONTAINER_STARTUP_CONFIG, false);
    }

    @Override
    public void registerObject(String key, Object defaultValue, String description) {
        Optional i = this.kvClient.getValueAsString(this.addSn(key));
        if (!i.isPresent()) {
            this.kvClient.putValue(this.addSn(key), this.toJson(defaultValue));
        }
    }

    @Override
    public void registerPassword(String key, String defaultValue, String description) {
        this.register(key, defaultValue, "xs:string", description, ConfigurationScope.CONTAINER_STARTUP_CONFIG, true);
    }

    private void register(String key, String defaultValue, String valueType, String description, ConfigurationScope configurationScope, boolean isPassword) {
        Optional i = this.kvClient.getValueAsString(this.addSn(key));
        ConfigItem configItem = this.prepareConfigItem(valueType, description, configurationScope, isPassword);
        if (!i.isPresent()) {
            String envVariable = System.getenv(key);
            if (envVariable != null) {
                configItem.setValue(envVariable);
                this.kvClient.putValue(this.addSn(key), this.toJson(configItem));
            } else {
                configItem.setValue(defaultValue);
                this.kvClient.putValue(this.addSn(key), this.toJson(configItem));
            }
        }
        if (this.configProps != null) {
            this.configProps.put(key, this.getString(key));
        }
    }

    @Override
    public boolean getBoolean(String key) {
        return Boolean.parseBoolean(this.getString(key));
    }

    @Override
    public int getInteger(String key) {
        return Integer.parseInt(this.getString(key));
    }

    @Override
    public double getDouble(String key) {
        return Double.parseDouble(this.getString(key));
    }

    @Override
    public String getString(String key) {
        return this.getConfigItem(key).getValue();
    }

    @Override
    public <T> T getObject(String key, Class<T> clazz, T defaultValue) {
        Optional os = this.kvClient.getValueAsString(this.addSn(key));
        if (os.isPresent()) {
            Gson gson = new Gson();
            return (T)gson.fromJson((String)os.get(), clazz);
        }
        return defaultValue;
    }

    @Override
    public ConfigItem getConfigItem(String key) {
        Optional os = this.kvClient.getValueAsString(this.addSn(key));
        return this.fromJson((String)os.get());
    }

    @Override
    public void setBoolean(String key, Boolean value) {
        this.setString(key, value.toString());
    }

    @Override
    public void setInteger(String key, int value) {
        this.setString(key, String.valueOf(value));
    }

    @Override
    public void setDouble(String key, double value) {
        this.setString(key, String.valueOf(value));
    }

    @Override
    public void setString(String key, String value) {
        this.kvClient.putValue(this.addSn(key), value);
    }

    @Override
    public void setObject(String key, Object value) {
        Gson gson = new Gson();
        this.kvClient.putValue(this.addSn(key), gson.toJson(value));
    }

    private String addSn(String key) {
        return SERVICE_ROUTE_PREFIX + this.serviceName + "/" + key;
    }

    private ConfigItem fromJson(String content) {
        try {
            return (ConfigItem)new Gson().fromJson(content, ConfigItem.class);
        }
        catch (Exception e) {
            ConfigItem configItem = new ConfigItem();
            configItem.setValue(content);
            return configItem;
        }
    }

    private ConfigItem prepareConfigItem(String valueType, String description, ConfigurationScope configurationScope, boolean password) {
        ConfigItem configItem = new ConfigItem();
        configItem.setValueType(valueType);
        configItem.setDescription(description);
        configItem.setPassword(password);
        configItem.setConfigurationScope(configurationScope);
        return configItem;
    }

    private String toJson(Object object) {
        return new Gson().toJson(object);
    }
}

