/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.config.backend;

import java.io.File;
import java.security.SecureRandom;
import java.util.Random;
import org.apache.commons.lang3.RandomStringUtils;
import org.streampipes.config.SpConfig;
import org.streampipes.config.backend.MessagingSettings;

public enum BackendConfig {
    INSTANCE;

    private final char[] possibleCharacters = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789~`!@#$%^&*()-_=+[{]}\\|;:'\",<.>/?".toCharArray();
    private SpConfig config = SpConfig.getSpConfig("backend");

    private BackendConfig() {
        this.config.register("SP_SERVICE_NAME", "Backend", "Backend Configuration");
        this.config.register("SP_BACKEND_HOST", "backend", "Hostname for backend");
        this.config.register("SP_BACKEND_PORT", 8030, "Port for backend");
        this.config.register("SP_JMS_HOST", "activemq", "Hostname for backend service for active mq");
        this.config.register("SP_JMS_PORT", 61616, "Port for backend service for active mq");
        this.config.register("SP_KAFKA_HOST", "kafka", "Hostname for backend service for kafka");
        this.config.register("SP_KAFKA_PORT", 9092, "Port for backend service for kafka");
        this.config.register("SP_ZOOKEEPER_HOST", "zookeeper", "Hostname for backend service for zookeeper");
        this.config.register("SP_ZOOKEEPER_PORT", 2181, "Port for backend service for zookeeper");
        this.config.register("SP_ELASTICSEARCH_HOST", "elasticsearch", "Hostname for elasticsearch service");
        this.config.register("SP_ELASTICSEARCH_PORT", 9200, "Port for elasticsearch service");
        this.config.register("SP_ELASTICSEARCH_PROTOCOL", "http", "Protocol the elasticsearch service");
        this.config.register("SP_IS_CONFIGURED", false, "Boolean that indicates whether streampipes is already configured or not");
        this.config.register("SP_KAFKA_REST_HOST", "kafka-rest", "The hostname of the kafka-rest module");
        this.config.register("SP_KAFKA_REST_PORT", 8082, "The port of the kafka-rest module");
        this.config.register("SP_KAFKA_REST_HOST", "kafka-rest", "The hostname of the kafka-rest module");
        this.config.register("SP_ASSETS_DIR", this.makeAssetLocation(), "The directory where pipeline element assets are stored.");
        this.config.register("SP_FILES_DIR", this.makeFileLocation(), "The directory where pipeline element files are stored.");
        this.config.register("SP_DATA_LAKE_HOST", "elasticsearch", "The host of the data base used for the data lake");
        this.config.register("SP_DATA_LAKE_PORT", 9200, "The port of the data base used for the data lake");
        this.config.register("SP_INFLUX_HOST", "influxdb", "The host of the influx data base");
        this.config.register("SP_INFLUX_PORT", 8086, "The hist of the influx data base");
        this.config.register("SP_INFLUX_DATA_BASE", "sp", "The influx data base name");
        this.config.registerObject("SP_MESSAGING_SETTINGS", MessagingSettings.fromDefault(), "Default Messaging Settings");
        this.config.register("SP_ENCRYPTION_KEY", this.randomKey(), "A random secret key");
    }

    private String makeAssetLocation() {
        return this.makeStreamPipesHomeLocation() + "assets";
    }

    private String makeFileLocation() {
        return this.makeStreamPipesHomeLocation() + "files";
    }

    private String makeStreamPipesHomeLocation() {
        return System.getProperty("user.home") + File.separator + ".streampipes" + File.separator;
    }

    private String randomKey() {
        return RandomStringUtils.random((int)10, (int)0, (int)(this.possibleCharacters.length - 1), (boolean)false, (boolean)false, (char[])this.possibleCharacters, (Random)new SecureRandom());
    }

    public String getBackendHost() {
        return this.config.getString("SP_BACKEND_HOST");
    }

    public int getBackendPort() {
        return this.config.getInteger("SP_BACKEND_PORT");
    }

    public String getBackendUrl() {
        return "http://" + this.getBackendHost() + ":" + this.getBackendPort();
    }

    public String getJmsHost() {
        return this.config.getString("SP_JMS_HOST");
    }

    public int getJmsPort() {
        return this.config.getInteger("SP_JMS_PORT");
    }

    public String getKafkaHost() {
        return this.config.getString("SP_KAFKA_HOST");
    }

    public int getKafkaPort() {
        return this.config.getInteger("SP_KAFKA_PORT");
    }

    public String getKafkaUrl() {
        return this.getKafkaHost() + ":" + this.getKafkaPort();
    }

    public String getZookeeperHost() {
        return this.config.getString("SP_ZOOKEEPER_HOST");
    }

    public int getZookeeperPort() {
        return this.config.getInteger("SP_ZOOKEEPER_PORT");
    }

    public MessagingSettings getMessagingSettings() {
        return this.config.getObject("SP_MESSAGING_SETTINGS", MessagingSettings.class, new MessagingSettings());
    }

    public boolean isConfigured() {
        return this.config.getBoolean("SP_IS_CONFIGURED");
    }

    public void setKafkaHost(String s) {
        this.config.setString("SP_KAFKA_HOST", s);
    }

    public void setZookeeperHost(String s) {
        this.config.setString("SP_ZOOKEEPER_HOST", s);
    }

    public void setJmsHost(String s) {
        this.config.setString("SP_JMS_HOST", s);
    }

    public void setMessagingSettings(MessagingSettings settings) {
        this.config.setObject("SP_MESSAGING_SETTINGS", settings);
    }

    public void setIsConfigured(boolean b) {
        this.config.setBoolean("SP_IS_CONFIGURED", b);
    }

    public String getElasticsearchHost() {
        return this.config.getString("SP_ELASTICSEARCH_HOST");
    }

    public int getElasticsearchPort() {
        return this.config.getInteger("SP_ELASTICSEARCH_PORT");
    }

    public String getElasticsearchProtocol() {
        return this.config.getString("SP_ELASTICSEARCH_PROTOCOL");
    }

    public String getElasticsearchURL() {
        return this.getElasticsearchProtocol() + "://" + this.getElasticsearchHost() + ":" + this.getElasticsearchPort();
    }

    public String getKafkaRestHost() {
        return this.config.getString("SP_KAFKA_REST_HOST");
    }

    public Integer getKafkaRestPort() {
        return this.config.getInteger("SP_KAFKA_REST_PORT");
    }

    public String getKafkaRestUrl() {
        return "http://" + this.getKafkaRestHost() + ":" + this.getKafkaRestPort();
    }

    public String getAssetDir() {
        return this.config.getString("SP_ASSETS_DIR");
    }

    public String getFilesDir() {
        return this.config.getString("SP_FILES_DIR");
    }

    public String getDatalakeHost() {
        return this.config.getString("SP_DATA_LAKE_HOST");
    }

    public int getDatalakePort() {
        return this.config.getInteger("SP_DATA_LAKE_PORT");
    }

    public String getDataLakeUrl() {
        return this.getDatalakeHost() + ":" + this.getDatalakePort();
    }

    public String getInfluxHost() {
        return this.config.getString("SP_INFLUX_HOST");
    }

    public int getInfluxPort() {
        return this.config.getInteger("SP_INFLUX_PORT");
    }

    public String getInfluxUrl() {
        return "http://" + this.getInfluxHost() + ":" + this.getInfluxPort();
    }

    public String getInfluxDatabaseName() {
        return this.config.getString("SP_INFLUX_DATA_BASE");
    }

    public String getEncryptionKey() {
        return this.config.getString("SP_ENCRYPTION_KEY");
    }
}

