/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.connect.config;

import org.streampipes.config.SpConfig;
import org.streampipes.connect.init.Config;

public enum ConnectContainerConfig {
    INSTANCE;

    private SpConfig config = SpConfig.getSpConfig((String)"connect-container");

    private ConnectContainerConfig() {
        this.config.register("SP_KAFKA_HOST", "kafka", "Hostname for backend service for kafka");
        this.config.register("SP_KAFKA_PORT", 9092, "Port for backend service for kafka");
        this.config.register("SP_BACKEND_HOST", "backend", "Hostname for backend");
        this.config.register("SP_BACKEND_PORT", 8030, "Port for backend");
        this.config.register("SP_CONNECT_CONTAINER_PORT", Config.MASTER_PORT, "The port of the connect container");
        this.config.register("SP_CONNECT_CONTAINER_HOST", "connect-master", "The hostname of the connect container");
        this.config.register("SP_DATA_LOCATION", "/data/", "Folder that stores all the uploaded data");
    }

    public String getBackendApiUrl() {
        return this.config.getString("SP_BACKEND_HOST") + ":" + this.config.getInteger("SP_BACKEND_PORT") + "/streampipes-backend/";
    }

    public String getConnectContainerMasterUrl() {
        return "http://" + this.getConnectContainerMasterHost() + ":" + this.getConnectContainerMasterPort() + "/";
    }

    public String getBackendHost() {
        return this.config.getString("SP_BACKEND_HOST");
    }

    public int getBackendPort() {
        return this.config.getInteger("SP_BACKEND_PORT");
    }

    public String getConnectContainerMasterHost() {
        return this.config.getString("SP_CONNECT_CONTAINER_HOST");
    }

    public Integer getConnectContainerMasterPort() {
        return this.config.getInteger("SP_CONNECT_CONTAINER_PORT");
    }

    public String getDataLocation() {
        return this.config.getString("SP_DATA_LOCATION");
    }

    public String getKafkaHost() {
        return this.config.getString("SP_KAFKA_HOST");
    }

    public int getKafkaPort() {
        return this.config.getInteger("SP_KAFKA_PORT");
    }

    public String getKafkaUrl() {
        return this.getKafkaHost() + ":" + this.getKafkaPort();
    }
}

