/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.connect.init;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.streampipes.connect.adapter.Adapter;
import org.streampipes.connect.adapter.model.Connector;
import org.streampipes.connect.adapter.model.generic.GenericDataSetAdapter;
import org.streampipes.connect.adapter.model.generic.GenericDataStreamAdapter;
import org.streampipes.connect.adapter.model.generic.Protocol;

public class AdapterDeclarerSingleton {
    private Map<String, Protocol> allProtocols = new HashMap<String, Protocol>();
    private Map<String, Adapter> allAdapters = new HashMap<String, Adapter>();
    private static AdapterDeclarerSingleton instance;

    public AdapterDeclarerSingleton() {
        this.allAdapters.put("http://streampipes.org/genericadapterstreamdescription", (Adapter)new GenericDataStreamAdapter());
        this.allAdapters.put("http://streampipes.org/genericadaptersetdescription", (Adapter)new GenericDataSetAdapter());
    }

    public static AdapterDeclarerSingleton getInstance() {
        if (instance == null) {
            instance = new AdapterDeclarerSingleton();
        }
        return instance;
    }

    public AdapterDeclarerSingleton add(Connector c) {
        if (c instanceof Protocol) {
            this.allProtocols.put(((Protocol)c).getId(), (Protocol)c);
        } else if (c instanceof Adapter) {
            this.allAdapters.put(((Adapter)c).getId(), (Adapter)c);
        }
        return AdapterDeclarerSingleton.getInstance();
    }

    public Map<String, Protocol> getAllProtocolsMap() {
        return this.allProtocols;
    }

    public Map<String, Adapter> getAllAdaptersMap() {
        return this.allAdapters;
    }

    public Collection<Protocol> getAllProtocols() {
        return this.allProtocols.values();
    }

    public Collection<Adapter> getAllAdapters() {
        return this.allAdapters.values();
    }

    public Protocol getProtocol(String id) {
        return this.getAllProtocols().stream().filter(protocol -> protocol.getId().equals(id)).findAny().orElse(null);
    }

    public Adapter getAdapter(String id) {
        return this.getAllAdapters().stream().filter(adapter -> adapter.getId().equals(id)).findAny().orElse(null);
    }
}

