/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.connect.management;

import java.io.IOException;
import org.apache.http.client.fluent.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.streampipes.connect.adapter.Adapter;
import org.streampipes.connect.adapter.model.generic.GenericAdapter;
import org.streampipes.connect.adapter.model.generic.GenericDataSetAdapter;
import org.streampipes.connect.adapter.model.generic.GenericDataStreamAdapter;
import org.streampipes.connect.adapter.model.generic.Protocol;
import org.streampipes.connect.init.AdapterDeclarerSingleton;
import org.streampipes.model.connect.adapter.AdapterDescription;
import org.streampipes.model.connect.adapter.GenericAdapterSetDescription;
import org.streampipes.model.connect.adapter.GenericAdapterStreamDescription;

public class AdapterUtils {
    private static final Logger logger = LoggerFactory.getLogger(AdapterUtils.class);

    public static String stopPipeline(String url) {
        logger.info("Send stopAdapter pipeline request on URL: " + url);
        String result = "";
        try {
            result = Request.Get((String)url).connectTimeout(1000).socketTimeout(100000).execute().returnContent().asString();
        }
        catch (IOException e) {
            e.printStackTrace();
            result = e.getMessage();
        }
        logger.info("Successfully stopped pipeline");
        return result;
    }

    public static String getUrl(String baseUrl, String pipelineId) {
        return "http://" + baseUrl + "api/v2/pipelines/" + pipelineId + "/stopAdapter";
    }

    public static Adapter setAdapter(AdapterDescription adapterDescription) {
        Adapter adapter = null;
        if (adapterDescription instanceof GenericAdapterStreamDescription) {
            adapter = new GenericDataStreamAdapter().getInstance((GenericAdapterStreamDescription)adapterDescription);
        } else if (adapterDescription instanceof GenericAdapterSetDescription) {
            adapter = new GenericDataSetAdapter().getInstance((GenericAdapterSetDescription)adapterDescription);
        }
        Protocol protocol = null;
        if (adapterDescription instanceof GenericAdapterSetDescription) {
            protocol = AdapterDeclarerSingleton.getInstance().getProtocol(((GenericAdapterSetDescription)adapterDescription).getProtocolDescription().getElementId());
            ((GenericAdapter)adapter).setProtocol(protocol);
        }
        if (adapterDescription instanceof GenericAdapterStreamDescription) {
            protocol = AdapterDeclarerSingleton.getInstance().getProtocol(((GenericAdapterStreamDescription)adapterDescription).getProtocolDescription().getElementId());
            ((GenericAdapter)adapter).setProtocol(protocol);
        }
        if (adapter == null) {
            adapter = AdapterDeclarerSingleton.getInstance().getAdapter(adapterDescription.getAppId()).getInstance(adapterDescription);
        }
        return adapter;
    }
}

