/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.container.standalone.init;

import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.core.UriBuilder;
import org.eclipse.jetty.server.Server;
import org.glassfish.jersey.jetty.JettyHttpContainerFactory;
import org.glassfish.jersey.server.ResourceConfig;
import org.streampipes.container.api.Element;
import org.streampipes.container.api.InvocableElement;
import org.streampipes.container.api.PipelineTemplateElement;
import org.streampipes.container.api.SecElement;
import org.streampipes.container.api.SepElement;
import org.streampipes.container.api.SepaElement;
import org.streampipes.container.api.WelcomePage;
import org.streampipes.container.init.DeclarersSingleton;
import org.streampipes.container.init.ModelSubmitter;
import org.streampipes.container.model.PeConfig;
import org.streampipes.container.util.ConsulUtil;

public abstract class StandaloneModelSubmitter
extends ModelSubmitter {
    public void init(PeConfig peConfig) {
        DeclarersSingleton.getInstance().setHostName(peConfig.getHost());
        DeclarersSingleton.getInstance().setPort(peConfig.getPort());
        URI baseUri = UriBuilder.fromUri((String)DeclarersSingleton.getInstance().getBaseUri()).build(new Object[0]);
        ResourceConfig config = new ResourceConfig(this.getApiClasses());
        Server server = JettyHttpContainerFactory.createServer((URI)baseUri, (ResourceConfig)config);
        ConsulUtil.registerPeService((String)peConfig.getId(), (String)peConfig.getHost(), (int)peConfig.getPort());
    }

    private Set<Class<?>> getApiClasses() {
        HashSet allClasses = new HashSet();
        allClasses.add(Element.class);
        allClasses.add(InvocableElement.class);
        allClasses.add(SecElement.class);
        allClasses.add(SepaElement.class);
        allClasses.add(SepElement.class);
        allClasses.add(WelcomePage.class);
        allClasses.add(PipelineTemplateElement.class);
        return allClasses;
    }
}

