/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.container.standalone.init;

import java.util.Collections;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.streampipes.container.init.DeclarersSingleton;
import org.streampipes.container.init.ModelSubmitter;
import org.streampipes.container.init.RunningInstances;
import org.streampipes.container.model.PeConfig;
import org.streampipes.container.standalone.init.PipelineElementContainerResourceConfig;
import org.streampipes.container.util.ConsulUtil;

@Configuration
@EnableAutoConfiguration
@Import(value={PipelineElementContainerResourceConfig.class})
public abstract class StandaloneModelSubmitter
extends ModelSubmitter {
    private static final Logger LOG = LoggerFactory.getLogger((String)StandaloneModelSubmitter.class.getCanonicalName());

    public void init(PeConfig peConfig) {
        DeclarersSingleton.getInstance().setHostName(peConfig.getHost());
        DeclarersSingleton.getInstance().setPort(peConfig.getPort());
        SpringApplication app = new SpringApplication(new Class[]{StandaloneModelSubmitter.class});
        app.setDefaultProperties(Collections.singletonMap("server.port", peConfig.getPort()));
        app.run(new String[0]);
        ConsulUtil.registerPeService((String)peConfig.getId(), (String)peConfig.getHost(), (int)peConfig.getPort());
    }

    @PreDestroy
    public void onExit() {
        LOG.info("Shutting down StreamPipes pipeline element container...");
        Integer runningInstancesCount = RunningInstances.INSTANCE.getRunningInstancesCount();
        while (runningInstancesCount > 0) {
            LOG.info("Waiting for {} running pipeline elements to be stopped...", (Object)runningInstancesCount);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                LOG.error("Could not pause current thread...");
            }
            runningInstancesCount = RunningInstances.INSTANCE.getRunningInstancesCount();
        }
    }
}

