/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.container.api;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.rdf4j.model.Graph;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.streampipes.commons.Utils;
import org.streampipes.container.declarer.DataStreamDeclarer;
import org.streampipes.container.declarer.Declarer;
import org.streampipes.container.declarer.SemanticEventProducerDeclarer;
import org.streampipes.container.init.DeclarersSingleton;
import org.streampipes.container.transform.Transformer;
import org.streampipes.empire.core.empire.SupportsRdfId;
import org.streampipes.empire.core.empire.annotation.InvalidRdfException;
import org.streampipes.model.SpDataStream;
import org.streampipes.model.base.NamedStreamPipesEntity;
import org.streampipes.model.graph.DataProcessorDescription;
import org.streampipes.model.graph.DataSinkDescription;
import org.streampipes.model.graph.DataSourceDescription;

public abstract class Element<D extends Declarer> {
    protected abstract List<D> getElementDeclarers();

    @GET
    @Path(value="{id}")
    @Produces(value={"application/json"})
    public String getDescription(@PathParam(value="id") String elementId) {
        return this.getJsonLd(elementId);
    }

    protected String getJsonLd(String id) {
        NamedStreamPipesEntity elem = this.rewrite(this.getById(id));
        return this.toJsonLd(elem);
    }

    protected String getJsonLd(NamedStreamPipesEntity desc, String appendix) {
        return this.toJsonLd(this.rewrite(desc, appendix));
    }

    protected D getDeclarerById(String id) {
        for (Declarer declarer : this.getElementDeclarers()) {
            if (!declarer.declareModel().getUri().equals(id)) continue;
            return (D)declarer;
        }
        return null;
    }

    protected NamedStreamPipesEntity getById(String id) {
        DataSourceDescription desc = null;
        for (Declarer declarer : this.getElementDeclarers()) {
            if (!declarer.declareModel().getUri().equals(id)) continue;
            if (declarer instanceof SemanticEventProducerDeclarer) {
                DataSourceDescription secDesc = (DataSourceDescription)((SemanticEventProducerDeclarer)declarer).declareModel();
                List<DataStreamDeclarer> eventStreamDeclarers = ((SemanticEventProducerDeclarer)declarer).getEventStreams();
                for (DataStreamDeclarer esd : eventStreamDeclarers) {
                    secDesc.addEventStream(esd.declareModel(secDesc));
                }
                desc = secDesc;
                continue;
            }
            desc = (DataSourceDescription)declarer.declareModel();
        }
        return desc;
    }

    protected NamedStreamPipesEntity rewrite(NamedStreamPipesEntity desc) {
        return this.rewrite(desc, "");
    }

    protected NamedStreamPipesEntity rewrite(NamedStreamPipesEntity desc, String appendix) {
        if (desc != null) {
            String type = "";
            if (desc instanceof DataProcessorDescription) {
                type = "sepa/";
            } else if (desc instanceof DataSourceDescription) {
                type = "sep/";
            } else if (desc instanceof DataSinkDescription) {
                type = "sec/";
            } else if (desc instanceof SpDataStream) {
                type = "sep/" + appendix + "/";
            }
            String originalId = desc.getUri();
            String uri = DeclarersSingleton.getInstance().getBaseUri() + type + desc.getUri();
            desc.setUri(uri);
            desc.setRdfId((SupportsRdfId.RdfKey)new SupportsRdfId.URIKey(URI.create(uri)));
            if (desc instanceof DataSourceDescription) {
                for (SpDataStream stream : ((DataSourceDescription)desc).getSpDataStreams()) {
                    String baseUri = DeclarersSingleton.getInstance().getBaseUri() + type + originalId + "/" + stream.getUri();
                    stream.setUri(baseUri);
                    stream.setRdfId((SupportsRdfId.RdfKey)new SupportsRdfId.URIKey(URI.create(baseUri)));
                }
            }
        }
        return desc;
    }

    protected String toJsonLd(NamedStreamPipesEntity namedElement) {
        if (namedElement != null) {
            try {
                Graph rdfGraph = Transformer.toJsonLd(namedElement);
                return Utils.asString((Graph)rdfGraph);
            }
            catch (ClassNotFoundException | IllegalAccessException | InvocationTargetException | RDFHandlerException | InvalidRdfException e) {
                e.printStackTrace();
            }
        }
        return "{}";
    }
}

