/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.container.api;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.streampipes.container.api.Element;
import org.streampipes.container.declarer.DataSetDeclarer;
import org.streampipes.container.declarer.DataStreamDeclarer;
import org.streampipes.container.declarer.SemanticEventProducerDeclarer;
import org.streampipes.container.init.DeclarersSingleton;
import org.streampipes.container.init.RunningDatasetInstances;
import org.streampipes.container.transform.Transformer;
import org.streampipes.container.util.Util;
import org.streampipes.model.Response;
import org.streampipes.model.SpDataSet;
import org.streampipes.model.SpDataStream;
import org.streampipes.model.base.NamedStreamPipesEntity;
import org.streampipes.model.graph.DataSourceDescription;

@Path(value="/sep")
public class SepElement
extends Element<SemanticEventProducerDeclarer> {
    @Override
    protected List<SemanticEventProducerDeclarer> getElementDeclarers() {
        return DeclarersSingleton.getInstance().getProducerDeclarers();
    }

    @GET
    @Path(value="{sourceId}/{streamId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String getDescription(@PathParam(value="sourceId") String sourceId, @PathParam(value="streamId") String streamId) {
        Optional<SpDataStream> stream = this.getStreamBySourceId(sourceId, streamId);
        if (stream.isPresent()) {
            return this.getJsonLd((NamedStreamPipesEntity)stream.get(), this.getById(sourceId).getUri());
        }
        return "{}";
    }

    private Optional<SpDataStream> getStreamBySourceId(String sourceId, String streamId) {
        DataSourceDescription dataSourceDescription = (DataSourceDescription)this.getById(sourceId);
        return dataSourceDescription.getSpDataStreams().stream().filter(ds -> ds.getElementId().equals(streamId)).findFirst();
    }

    @POST
    @Path(value="{sourceId}/{streamId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String invokeRuntime(@PathParam(value="sourceId") String sourceId, @PathParam(value="streamId") String streamId, String payload) {
        SemanticEventProducerDeclarer declarer = (SemanticEventProducerDeclarer)this.getDeclarerById(sourceId);
        Optional<DataStreamDeclarer> streamDeclarer = declarer.getEventStreams().stream().filter(sd -> sd.declareModel((DataSourceDescription)declarer.declareModel()).getElementId().equals(streamId)).findFirst();
        if (streamDeclarer.isPresent()) {
            try {
                SpDataSet dataSet = Transformer.fromJsonLd(SpDataSet.class, payload, "https://streampipes.org/vocabulary/v1/DataSet");
                String runningInstanceId = dataSet.getDatasetInvocationId();
                RunningDatasetInstances.INSTANCE.add(runningInstanceId, (NamedStreamPipesEntity)dataSet, (DataSetDeclarer)streamDeclarer.get().getClass().newInstance());
                boolean success = RunningDatasetInstances.INSTANCE.getInvocation(runningInstanceId).invokeRuntime(dataSet, () -> {});
                return Util.toResponseString(new Response(runningInstanceId, true));
            }
            catch (IOException | IllegalAccessException | InstantiationException | RepositoryException | RDFParseException e) {
                e.printStackTrace();
                return Util.toResponseString(new Response("", false, e.getMessage()));
            }
        }
        return Util.toResponseString("", false, "Could not find the element with id: ");
    }

    @DELETE
    @Path(value="{sourceId}/{streamId}/{runningInstanceId}")
    @Produces(value={"application/json"})
    public String detach(@PathParam(value="runningInstanceId") String runningInstanceId) {
        DataSetDeclarer runningInstance = RunningDatasetInstances.INSTANCE.getInvocation(runningInstanceId);
        if (runningInstance != null) {
            boolean detachSuccess = runningInstance.detachRuntime(runningInstanceId);
            Response resp = new Response("", detachSuccess);
            if (resp.isSuccess()) {
                RunningDatasetInstances.INSTANCE.remove(runningInstanceId);
            }
            return Util.toResponseString(resp);
        }
        return Util.toResponseString(runningInstanceId, false, "Could not find the running instance with id: " + runningInstanceId);
    }
}

