/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.container.util;

import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import com.orbitz.consul.AgentClient;
import com.orbitz.consul.Consul;
import com.orbitz.consul.HealthClient;
import com.orbitz.consul.KeyValueClient;
import com.orbitz.consul.model.ConsulResponse;
import com.orbitz.consul.model.health.HealthCheck;
import com.orbitz.consul.model.health.Service;
import com.orbitz.consul.model.health.ServiceHealth;
import com.orbitz.consul.model.kv.Value;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsulUtil {
    private static final String PROTOCOL = "http://";
    private static final String HEALTH_CHECK_INTERVAL = "10s";
    private static final String PE_SERVICE_NAME = "pe";
    private static final String CONSUL_ENV_LOCATION = "CONSUL_LOCATION";
    private static final String CONSUL_URL_REGISTER_SERVICE = "v1/agent/service/register";
    static Logger LOG = LoggerFactory.getLogger(ConsulUtil.class);

    public static Consul consulInstance() {
        return Consul.builder().withUrl(ConsulUtil.consulURL()).build();
    }

    public static void registerPeService(String serviceID, String url, int port) {
        ConsulUtil.registerService(PE_SERVICE_NAME, serviceID, url, port, PE_SERVICE_NAME);
    }

    public static void registerService(String serviceName, String serviceID, String url, int port, String tag) {
        String body = ConsulUtil.createServiceRegisterBody(serviceName, serviceID, url, port, tag);
        try {
            ConsulUtil.registerServiceHttpClient(body);
            LOG.info("Register service " + serviceID, (Object)"succesful");
        }
        catch (UnirestException e) {
            LOG.error("Register service: " + serviceID, (Object)(" - " + e.toString()));
        }
    }

    public static Map<String, String> getPEServices() {
        LOG.info("Load PE service status");
        Consul consul = ConsulUtil.consulInstance();
        AgentClient agent = consul.agentClient();
        Map services = consul.agentClient().getServices();
        Map checks = agent.getChecks();
        HashMap<String, String> peServices = new HashMap<String, String>();
        for (Map.Entry entry : services.entrySet()) {
            if (!((Service)entry.getValue()).getTags().contains(PE_SERVICE_NAME)) continue;
            String serviceId = ((Service)entry.getValue()).getId();
            String serviceStatus = "critical";
            if (checks.containsKey("service:" + (String)entry.getKey())) {
                serviceStatus = ((HealthCheck)checks.get("service:" + (String)entry.getKey())).getStatus();
            }
            LOG.info("Service id: " + serviceId + " service status: " + serviceStatus);
            peServices.put(serviceId, serviceStatus);
        }
        return peServices;
    }

    public static Map<String, String> getKeyValue(String route) {
        Consul consul = ConsulUtil.consulInstance();
        KeyValueClient keyValueClient = consul.keyValueClient();
        HashMap<String, String> keyValues = new HashMap<String, String>();
        ConsulResponse consulResponseWithValues = keyValueClient.getConsulResponseWithValues(route);
        if (consulResponseWithValues.getResponse() != null) {
            for (Value value : (List)consulResponseWithValues.getResponse()) {
                String key = value.getKey();
                String v = "";
                if (value.getValueAsString().isPresent()) {
                    v = (String)value.getValueAsString().get();
                }
                LOG.info("Load key: " + route + " value: " + v);
                keyValues.put(key, v);
            }
        }
        return keyValues;
    }

    public static void updateConfig(String key, String value, String valueType, String description, boolean password) {
        Consul consul = ConsulUtil.consulInstance();
        KeyValueClient keyValueClient = consul.keyValueClient();
        if (!password) {
            keyValueClient.putValue(key, value);
        } else if (!value.equals("")) {
            keyValueClient.putValue(key, value);
        }
        keyValueClient.putValue(key + "_description", description);
        keyValueClient.putValue(key + "_type", valueType);
        LOG.info("Updated config - key:" + key + " value: " + value + " description: " + description + " type: " + valueType);
    }

    public static List<String> getActivePEServicesEndPoints() {
        LOG.info("Load active PE services endpoints");
        Consul consul = ConsulUtil.consulInstance();
        HealthClient healthClient = consul.healthClient();
        LinkedList<String> endpoints = new LinkedList<String>();
        List nodes = (List)healthClient.getHealthyServiceInstances(PE_SERVICE_NAME).getResponse();
        for (ServiceHealth node : nodes) {
            String endpoint = node.getService().getAddress() + ":" + node.getService().getPort();
            LOG.info("Active PE endpoint:" + endpoint);
            endpoints.add(endpoint);
        }
        return endpoints;
    }

    public static void deregisterService(String serviceId) {
        Consul consul = ConsulUtil.consulInstance();
        consul.agentClient().deregister(serviceId);
        LOG.info("Deregistered Service: " + serviceId);
    }

    private static int registerServiceHttpClient(String body) throws UnirestException {
        HttpResponse jsonResponse = Unirest.put((String)(ConsulUtil.consulURL().toString() + "/" + CONSUL_URL_REGISTER_SERVICE)).header("accept", "application/json").body(body).asJson();
        return jsonResponse.getStatus();
    }

    private static String createServiceRegisterBody(String name, String id, String url, int port, String tag) {
        String healthCheckURL = PROTOCOL + url + ":" + port;
        return "{\"ID\": \"" + id + "\",\"Name\": \"" + name + "\",\"Tags\": [    \"" + tag + "\",\"urlprefix-/" + id + " strip=/" + id + "\" ], \"Address\": \"" + PROTOCOL + url + "\", \"Port\":" + port + ", \"EnableTagOverride\": true,\"Check\": { \"Method\": \"GET\", \"http\":\"" + healthCheckURL + "\", \"interval\":\"" + HEALTH_CHECK_INTERVAL + "\" }}";
    }

    private static URL consulURL() {
        Map<String, String> env = System.getenv();
        URL url = null;
        if (env.containsKey(CONSUL_ENV_LOCATION)) {
            try {
                url = new URL("http", env.get(CONSUL_ENV_LOCATION), 8500, "");
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        } else {
            try {
                url = new URL("http", "localhost", 8500, "");
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return url;
    }
}

