/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.container.api;

import java.io.IOException;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.streampipes.container.api.Element;
import org.streampipes.container.api.ResolvesContainerProvidedOptions;
import org.streampipes.container.api.ResolvesContainerProvidedOutputStrategy;
import org.streampipes.container.declarer.Declarer;
import org.streampipes.container.declarer.InvocableDeclarer;
import org.streampipes.container.init.RunningInstances;
import org.streampipes.container.transform.Transformer;
import org.streampipes.container.util.Util;
import org.streampipes.model.Response;
import org.streampipes.model.base.InvocableStreamPipesEntity;
import org.streampipes.model.base.NamedStreamPipesEntity;
import org.streampipes.model.runtime.RuntimeOptions;
import org.streampipes.model.runtime.RuntimeOptionsRequest;
import org.streampipes.model.runtime.RuntimeOptionsResponse;
import org.streampipes.serializers.json.GsonSerializer;

public abstract class InvocableElement<I extends InvocableStreamPipesEntity, D extends Declarer>
extends Element<D> {
    protected Class<I> clazz;

    @Override
    protected abstract List<D> getElementDeclarers();

    protected abstract String getInstanceId(String var1, String var2);

    public InvocableElement(Class<I> clazz) {
        this.clazz = clazz;
    }

    @POST
    @Path(value="{elementId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String invokeRuntime(@PathParam(value="elementId") String elementId, String payload) {
        try {
            InvocableStreamPipesEntity graph = (InvocableStreamPipesEntity)Transformer.fromJsonLd(this.clazz, payload);
            InvocableDeclarer declarer = (InvocableDeclarer)this.getDeclarerById(elementId);
            if (declarer != null) {
                String runningInstanceId = this.getInstanceId(graph.getElementId(), elementId);
                RunningInstances.INSTANCE.add(runningInstanceId, (NamedStreamPipesEntity)graph, (InvocableDeclarer)declarer.getClass().newInstance());
                Response resp = RunningInstances.INSTANCE.getInvocation(runningInstanceId).invokeRuntime(graph);
                return Util.toResponseString(resp);
            }
        }
        catch (IOException | IllegalAccessException | InstantiationException | RepositoryException | RDFParseException e) {
            e.printStackTrace();
            return Util.toResponseString(new Response(elementId, false, e.getMessage()));
        }
        return Util.toResponseString(elementId, false, "Could not find the element with id: " + elementId);
    }

    @POST
    @Path(value="{elementId}/configurations")
    public String fetchConfigurations(@PathParam(value="elementId") String elementId, String payload) {
        RuntimeOptionsRequest runtimeOptionsRequest = (RuntimeOptionsRequest)GsonSerializer.getGsonWithIds().fromJson(payload, RuntimeOptionsRequest.class);
        ResolvesContainerProvidedOptions resolvesOptions = (ResolvesContainerProvidedOptions)this.getDeclarerById(elementId);
        List<RuntimeOptions> availableOptions = resolvesOptions.resolveOptions(runtimeOptionsRequest.getRequestId(), runtimeOptionsRequest.getMappedEventProperty());
        return GsonSerializer.getGsonWithIds().toJson((Object)new RuntimeOptionsResponse(runtimeOptionsRequest, availableOptions));
    }

    @POST
    @Path(value="{elementId}/output")
    public String fetchOutputStrategy(@PathParam(value="elementId") String elementId, String payload) {
        InvocableStreamPipesEntity runtimeOptionsRequest = (InvocableStreamPipesEntity)GsonSerializer.getGsonWithIds().fromJson(payload, this.clazz);
        ResolvesContainerProvidedOutputStrategy resolvesOutput = (ResolvesContainerProvidedOutputStrategy)this.getDeclarerById(elementId);
        return GsonSerializer.getGsonWithIds().toJson((Object)resolvesOutput.resolveOutputStrategy(runtimeOptionsRequest));
    }

    @DELETE
    @Path(value="{elementId}/{runningInstanceId}")
    @Produces(value={"application/json"})
    public String detach(@PathParam(value="elementId") String elementId, @PathParam(value="runningInstanceId") String runningInstanceId) {
        InvocableDeclarer runningInstance = RunningInstances.INSTANCE.getInvocation(runningInstanceId);
        if (runningInstance != null) {
            Response resp = runningInstance.detachRuntime(runningInstanceId);
            if (resp.isSuccess().booleanValue()) {
                RunningInstances.INSTANCE.remove(runningInstanceId);
            }
            return Util.toResponseString(resp);
        }
        return Util.toResponseString(elementId, false, "Could not find the running instance with id: " + runningInstanceId);
    }
}

