/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.container.html.page;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.streampipes.container.declarer.DataStreamDeclarer;
import org.streampipes.container.declarer.Declarer;
import org.streampipes.container.declarer.InvocableDeclarer;
import org.streampipes.container.declarer.PipelineTemplateDeclarer;
import org.streampipes.container.declarer.SemanticEventConsumerDeclarer;
import org.streampipes.container.declarer.SemanticEventProcessingAgentDeclarer;
import org.streampipes.container.declarer.SemanticEventProducerDeclarer;
import org.streampipes.container.html.model.DataSourceDescriptionHtml;
import org.streampipes.container.html.model.Description;
import org.streampipes.container.html.page.WelcomePageGenerator;
import org.streampipes.model.graph.DataSinkDescription;
import org.streampipes.model.graph.DataSourceDescription;

public class WelcomePageGeneratorImpl
extends WelcomePageGenerator<Declarer> {
    public WelcomePageGeneratorImpl(String baseUri, List<Declarer> declarers) {
        super(baseUri, declarers);
    }

    @Override
    public List<Description> buildUris() {
        ArrayList<Description> descriptions = new ArrayList<Description>();
        for (Declarer declarer : this.declarers) {
            if (declarer instanceof InvocableDeclarer) {
                descriptions.add(this.getDescription((InvocableDeclarer)declarer));
                continue;
            }
            if (declarer instanceof SemanticEventProducerDeclarer) {
                descriptions.add(this.getDescription((SemanticEventProducerDeclarer)declarer));
                continue;
            }
            if (!(declarer instanceof PipelineTemplateDeclarer)) continue;
            descriptions.add(this.getDescription(declarer));
        }
        return descriptions;
    }

    private Description getDescription(Declarer declarer) {
        Description desc = new Description();
        desc.setName(declarer.declareModel().getName());
        desc.setDescription(declarer.declareModel().getDescription());
        desc.setType(this.getType(declarer));
        String uri = this.baseUri;
        if (declarer instanceof SemanticEventConsumerDeclarer) {
            uri = uri + "sec/";
        } else if (declarer instanceof SemanticEventProcessingAgentDeclarer) {
            uri = uri + "sepa/";
        } else if (declarer instanceof PipelineTemplateDeclarer) {
            uri = uri + "template/";
        }
        desc.setUri(URI.create(uri + declarer.declareModel().getUri().replaceFirst("[a-zA-Z]{4}://[a-zA-Z\\.]+:\\d+/", "")));
        return desc;
    }

    private String getType(Declarer declarer) {
        if (declarer.declareModel() instanceof DataSinkDescription) {
            return "action";
        }
        return "sepa";
    }

    private Description getDescription(SemanticEventProducerDeclarer declarer) {
        ArrayList<Description> streams = new ArrayList<Description>();
        DataSourceDescriptionHtml desc = new DataSourceDescriptionHtml();
        desc.setName(((DataSourceDescription)declarer.declareModel()).getName());
        desc.setDescription(((DataSourceDescription)declarer.declareModel()).getDescription());
        desc.setUri(URI.create(this.baseUri + "sep/" + ((DataSourceDescription)declarer.declareModel()).getUri()));
        desc.setType("source");
        for (DataStreamDeclarer streamDeclarer : declarer.getEventStreams()) {
            Description ad = new Description();
            ad.setDescription(streamDeclarer.declareModel((DataSourceDescription)declarer.declareModel()).getDescription());
            ad.setUri(URI.create(this.baseUri + "stream/" + streamDeclarer.declareModel((DataSourceDescription)declarer.declareModel()).getUri()));
            ad.setName(streamDeclarer.declareModel((DataSourceDescription)declarer.declareModel()).getName());
            ad.setType("stream");
            streams.add(ad);
        }
        desc.setStreams(streams);
        return desc;
    }
}

