/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.container.init;

import java.util.ArrayList;
import java.util.List;
import org.streampipes.container.declarer.DataStreamDeclarer;
import org.streampipes.container.declarer.Declarer;
import org.streampipes.container.declarer.PipelineTemplateDeclarer;
import org.streampipes.container.declarer.SemanticEventConsumerDeclarer;
import org.streampipes.container.declarer.SemanticEventProcessingAgentDeclarer;
import org.streampipes.container.declarer.SemanticEventProducerDeclarer;
import org.streampipes.dataformat.SpDataFormatFactory;
import org.streampipes.dataformat.SpDataFormatManager;
import org.streampipes.messaging.SpProtocolDefinitionFactory;
import org.streampipes.messaging.SpProtocolManager;
import org.streampipes.model.graph.DataSourceDescription;

public class DeclarersSingleton {
    private static DeclarersSingleton instance;
    private List<SemanticEventProcessingAgentDeclarer> epaDeclarers = new ArrayList<SemanticEventProcessingAgentDeclarer>();
    private List<SemanticEventProducerDeclarer> producerDeclarers = new ArrayList<SemanticEventProducerDeclarer>();
    private List<SemanticEventConsumerDeclarer> consumerDeclarers = new ArrayList<SemanticEventConsumerDeclarer>();
    private List<PipelineTemplateDeclarer> pipelineTemplateDeclarers;
    private List<DataStreamDeclarer> streamDeclarers = new ArrayList<DataStreamDeclarer>();
    private int port;
    private String route = "/";
    private String hostName;

    private DeclarersSingleton() {
        this.pipelineTemplateDeclarers = new ArrayList<PipelineTemplateDeclarer>();
    }

    public static DeclarersSingleton getInstance() {
        if (instance == null) {
            instance = new DeclarersSingleton();
        }
        return instance;
    }

    public void addDeclarers(List<Declarer> allDeclarers) {
        for (Declarer d : allDeclarers) {
            this.add(d);
        }
    }

    public DeclarersSingleton add(Declarer d) {
        if (d instanceof SemanticEventProcessingAgentDeclarer) {
            this.addEpaDeclarer((SemanticEventProcessingAgentDeclarer)d);
        } else if (d instanceof SemanticEventProducerDeclarer) {
            this.addProducerDeclarer((SemanticEventProducerDeclarer)d);
        } else if (d instanceof SemanticEventConsumerDeclarer) {
            this.addConsumerDeclarer((SemanticEventConsumerDeclarer)d);
        } else if (d instanceof PipelineTemplateDeclarer) {
            this.addPipelineTemplateDeclarer((PipelineTemplateDeclarer)d);
        }
        return DeclarersSingleton.getInstance();
    }

    public List<Declarer> getDeclarers() {
        ArrayList<Declarer> result = new ArrayList<Declarer>();
        result.addAll(this.epaDeclarers);
        result.addAll(this.producerDeclarers);
        result.addAll(this.consumerDeclarers);
        result.addAll(this.pipelineTemplateDeclarers);
        return result;
    }

    public void registerProtocol(SpProtocolDefinitionFactory<?> protocol) {
        SpProtocolManager.INSTANCE.register(protocol);
    }

    public void registerDataFormat(SpDataFormatFactory dataFormatDefinition) {
        SpDataFormatManager.INSTANCE.register(dataFormatDefinition);
    }

    private void addEpaDeclarer(SemanticEventProcessingAgentDeclarer epaDeclarer) {
        this.epaDeclarers.add(epaDeclarer);
    }

    private void addProducerDeclarer(SemanticEventProducerDeclarer sourceDeclarer) {
        this.checkAndStartExecutableStreams(sourceDeclarer);
        this.producerDeclarers.add(sourceDeclarer);
        this.streamDeclarers.addAll(sourceDeclarer.getEventStreams());
    }

    private void addConsumerDeclarer(SemanticEventConsumerDeclarer consumerDeclarer) {
        this.consumerDeclarers.add(consumerDeclarer);
    }

    private void addPipelineTemplateDeclarer(PipelineTemplateDeclarer pipelineTemplateDeclarer) {
        this.pipelineTemplateDeclarers.add(pipelineTemplateDeclarer);
    }

    public List<SemanticEventProcessingAgentDeclarer> getEpaDeclarers() {
        return this.epaDeclarers;
    }

    public List<SemanticEventProducerDeclarer> getProducerDeclarers() {
        return this.producerDeclarers;
    }

    public List<SemanticEventConsumerDeclarer> getConsumerDeclarers() {
        return this.consumerDeclarers;
    }

    public List<PipelineTemplateDeclarer> getPipelineTemplateDeclarers() {
        return this.pipelineTemplateDeclarers;
    }

    public List<DataStreamDeclarer> getStreamDeclarers() {
        return this.streamDeclarers;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setHostName(String host) {
        this.hostName = host;
    }

    public void setRoute(String route) {
        this.route = "/" + route + "/";
    }

    public String getBaseUri() {
        return "http://" + this.hostName + ":" + this.port + this.route;
    }

    private void checkAndStartExecutableStreams(SemanticEventProducerDeclarer sourceDeclarer) {
        sourceDeclarer.getEventStreams().stream().filter(DataStreamDeclarer::isExecutable).forEach(es -> {
            es.declareModel((DataSourceDescription)sourceDeclarer.declareModel());
            es.executeStream();
        });
    }
}

